/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.window.draggable;

import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.view.MotionEvent;
import android.view.View;
import com.hjq.window.draggable.BaseDraggable;

public class SpringDraggable
extends BaseDraggable {
    public static final int ORIENTATION_HORIZONTAL = 0;
    public static final int ORIENTATION_VERTICAL = 1;
    private float mViewDownX;
    private float mViewDownY;
    private final int mOrientation;
    private boolean mTouchMoving;

    public SpringDraggable() {
        this(0);
    }

    public SpringDraggable(int orientation) {
        this.mOrientation = orientation;
        switch (this.mOrientation) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("You cannot pass in directions other than horizontal or vertical");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.mViewDownX = event.getX();
                this.mViewDownY = event.getY();
                this.mTouchMoving = false;
                break;
            }
            case 2: {
                float rawMoveX = event.getRawX() - (float)this.getWindowInvisibleWidth();
                float rawMoveY = event.getRawY() - (float)this.getWindowInvisibleHeight();
                float newX = rawMoveX - this.mViewDownX;
                float newY = rawMoveY - this.mViewDownY;
                if (newX < 0.0f) {
                    newX = 0.0f;
                }
                if (newY < 0.0f) {
                    newY = 0.0f;
                }
                this.updateLocation(newX, newY);
                if (this.mTouchMoving || !this.isFingerMove(this.mViewDownX, event.getX(), this.mViewDownY, event.getY())) break;
                this.mTouchMoving = true;
                break;
            }
            case 1: 
            case 3: {
                float rawMoveX = event.getRawX() - (float)this.getWindowInvisibleWidth();
                float rawMoveY = event.getRawY() - (float)this.getWindowInvisibleHeight();
                switch (this.mOrientation) {
                    case 0: {
                        float endX;
                        int screenWidth;
                        float startX = rawMoveX - this.mViewDownX;
                        if (startX < 0.0f) {
                            startX = 0.0f;
                        }
                        if (rawMoveX < (float)(screenWidth = this.getWindowWidth()) / 2.0f) {
                            endX = 0.0f;
                        } else {
                            endX = screenWidth - v.getWidth();
                            if (endX < 0.0f) {
                                endX = 0.0f;
                            }
                        }
                        float y = rawMoveY - this.mViewDownY;
                        this.startHorizontalAnimation(startX, endX, y);
                        break;
                    }
                    case 1: {
                        float endY;
                        int screenHeight;
                        float x = rawMoveX - this.mViewDownX;
                        float startY = rawMoveY - this.mViewDownY;
                        if (startY < 0.0f) {
                            startY = 0.0f;
                        }
                        if (rawMoveY < (float)(screenHeight = this.getWindowHeight()) / 2.0f) {
                            endY = 0.0f;
                        } else {
                            endY = screenHeight - v.getHeight();
                            if (endY < 0.0f) {
                                endY = 0.0f;
                            }
                        }
                        this.startVerticalAnimation(x, startY, endY);
                        break;
                    }
                }
                try {
                    boolean bl = this.mTouchMoving;
                    return bl;
                }
                finally {
                    this.mTouchMoving = false;
                }
            }
        }
        return false;
    }

    protected void startHorizontalAnimation(float startX, float endX, float y) {
        this.startHorizontalAnimation(startX, endX, y, this.calculateAnimationDuration(startX, endX));
    }

    protected void startHorizontalAnimation(float startX, float endX, float y, long duration) {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{startX, endX});
        animator.setDuration(duration);
        animator.addUpdateListener(animation -> this.updateLocation(((Float)animation.getAnimatedValue()).floatValue(), y));
        animator.start();
    }

    protected void startVerticalAnimation(float x, float startY, float endY) {
        this.startVerticalAnimation(x, startY, endY, this.calculateAnimationDuration(startY, endY));
    }

    protected void startVerticalAnimation(float x, float startY, float endY, long duration) {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{startY, endY});
        animator.setDuration(duration);
        animator.addUpdateListener(animation -> this.updateLocation(x, ((Float)animation.getAnimatedValue()).floatValue()));
        animator.start();
    }

    public long calculateAnimationDuration(float startCoordinate, float endCoordinate) {
        long animationDuration = (long)(Math.abs(endCoordinate - startCoordinate) / 2.0f);
        if (animationDuration > 800L) {
            animationDuration = 800L;
        }
        return animationDuration;
    }
}

