/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.toast.style;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import com.hjq.toast.config.IToastStyle;

public class ViewToastStyle
implements IToastStyle<View> {
    private final int mLayoutId;
    private final IToastStyle<?> mStyle;

    public ViewToastStyle(int id, IToastStyle<?> style) {
        this.mLayoutId = id;
        this.mStyle = style;
    }

    @Override
    public View createView(Context context) {
        return LayoutInflater.from((Context)context).inflate(this.mLayoutId, null);
    }

    @Override
    public int getGravity() {
        if (this.mStyle == null) {
            return 17;
        }
        return this.mStyle.getGravity();
    }

    @Override
    public int getXOffset() {
        if (this.mStyle == null) {
            return 0;
        }
        return this.mStyle.getXOffset();
    }

    @Override
    public int getYOffset() {
        if (this.mStyle == null) {
            return 0;
        }
        return this.mStyle.getYOffset();
    }

    @Override
    public float getHorizontalMargin() {
        if (this.mStyle == null) {
            return 0.0f;
        }
        return this.mStyle.getHorizontalMargin();
    }

    @Override
    public float getVerticalMargin() {
        if (this.mStyle == null) {
            return 0.0f;
        }
        return this.mStyle.getVerticalMargin();
    }
}

