/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hjq.permissions.AndroidVersion;
import com.hjq.permissions.PermissionUtils;

final class StartActivityManager {
    private static final String SUB_INTENT_KEY = "sub_intent_key";

    StartActivityManager() {
    }

    static Intent getSubIntentInMainIntent(@NonNull Intent mainIntent) {
        Intent subIntent = AndroidVersion.isAndroid13() ? (Intent)mainIntent.getParcelableExtra(SUB_INTENT_KEY, Intent.class) : (Intent)mainIntent.getParcelableExtra(SUB_INTENT_KEY);
        return subIntent;
    }

    static Intent getDeepSubIntent(@NonNull Intent superIntent) {
        Intent subIntent = StartActivityManager.getSubIntentInMainIntent(superIntent);
        if (subIntent != null) {
            return StartActivityManager.getDeepSubIntent(subIntent);
        }
        return superIntent;
    }

    static Intent addSubIntentToMainIntent(@Nullable Intent mainIntent, @Nullable Intent subIntent) {
        if (mainIntent == null && subIntent != null) {
            return subIntent;
        }
        if (subIntent == null) {
            return mainIntent;
        }
        Intent deepSubIntent = StartActivityManager.getDeepSubIntent(mainIntent);
        deepSubIntent.putExtra(SUB_INTENT_KEY, (Parcelable)subIntent);
        return mainIntent;
    }

    static boolean startActivity(@NonNull Context context, Intent intent) {
        return StartActivityManager.startActivity(new StartActivityDelegateContextImpl(context), intent);
    }

    static boolean startActivity(@NonNull Activity activity, Intent intent) {
        return StartActivityManager.startActivity(new StartActivityDelegateActivityImpl(activity), intent);
    }

    static boolean startActivity(@NonNull Fragment fragment, Intent intent) {
        return StartActivityManager.startActivity(new StartActivityDelegateFragmentImpl(fragment), intent);
    }

    static boolean startActivity(@NonNull android.support.v4.app.Fragment fragment, Intent intent) {
        return StartActivityManager.startActivity(new StartActivityDelegateSupportFragmentImpl(fragment), intent);
    }

    static boolean startActivity(@NonNull StartActivityDelegate delegate, @NonNull Intent intent) {
        try {
            delegate.startActivity(intent);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            Intent subIntent = StartActivityManager.getSubIntentInMainIntent(intent);
            if (subIntent == null) {
                return false;
            }
            return StartActivityManager.startActivity(delegate, subIntent);
        }
    }

    static boolean startActivityForResult(@NonNull Activity activity, @NonNull Intent intent, int requestCode) {
        return StartActivityManager.startActivityForResult(new StartActivityDelegateActivityImpl(activity), intent, requestCode);
    }

    static boolean startActivityForResult(@NonNull Fragment fragment, @NonNull Intent intent, int requestCode) {
        return StartActivityManager.startActivityForResult(new StartActivityDelegateFragmentImpl(fragment), intent, requestCode);
    }

    static boolean startActivityForResult(@NonNull android.support.v4.app.Fragment fragment, @NonNull Intent intent, int requestCode) {
        return StartActivityManager.startActivityForResult(new StartActivityDelegateSupportFragmentImpl(fragment), intent, requestCode);
    }

    static boolean startActivityForResult(@NonNull StartActivityDelegate delegate, @NonNull Intent intent, int requestCode) {
        try {
            delegate.startActivityForResult(intent, requestCode);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            Intent subIntent = StartActivityManager.getSubIntentInMainIntent(intent);
            if (subIntent == null) {
                return false;
            }
            return StartActivityManager.startActivityForResult(delegate, subIntent, requestCode);
        }
    }

    private static class StartActivityDelegateSupportFragmentImpl
    implements StartActivityDelegate {
        private final android.support.v4.app.Fragment mFragment;

        private StartActivityDelegateSupportFragmentImpl(@NonNull android.support.v4.app.Fragment fragment) {
            this.mFragment = fragment;
        }

        @Override
        public void startActivity(@NonNull Intent intent) {
            this.mFragment.startActivity(intent);
        }

        @Override
        public void startActivityForResult(@NonNull Intent intent, int requestCode) {
            this.mFragment.startActivityForResult(intent, requestCode);
        }
    }

    private static class StartActivityDelegateFragmentImpl
    implements StartActivityDelegate {
        private final Fragment mFragment;

        private StartActivityDelegateFragmentImpl(@NonNull Fragment fragment) {
            this.mFragment = fragment;
        }

        @Override
        public void startActivity(@NonNull Intent intent) {
            this.mFragment.startActivity(intent);
        }

        @Override
        public void startActivityForResult(@NonNull Intent intent, int requestCode) {
            this.mFragment.startActivityForResult(intent, requestCode);
        }
    }

    private static class StartActivityDelegateActivityImpl
    implements StartActivityDelegate {
        private final Activity mActivity;

        private StartActivityDelegateActivityImpl(@NonNull Activity activity) {
            this.mActivity = activity;
        }

        @Override
        public void startActivity(@NonNull Intent intent) {
            this.mActivity.startActivity(intent);
        }

        @Override
        public void startActivityForResult(@NonNull Intent intent, int requestCode) {
            this.mActivity.startActivityForResult(intent, requestCode);
        }
    }

    private static class StartActivityDelegateContextImpl
    implements StartActivityDelegate {
        private final Context mContext;

        private StartActivityDelegateContextImpl(@NonNull Context context) {
            this.mContext = context;
        }

        @Override
        public void startActivity(@NonNull Intent intent) {
            this.mContext.startActivity(intent);
        }

        @Override
        public void startActivityForResult(@NonNull Intent intent, int requestCode) {
            Activity activity = PermissionUtils.findActivity(this.mContext);
            if (activity != null) {
                activity.startActivityForResult(intent, requestCode);
                return;
            }
            this.startActivity(intent);
        }
    }

    private static interface StartActivityDelegate {
        public void startActivity(@NonNull Intent var1);

        public void startActivityForResult(@NonNull Intent var1, int var2);
    }
}

