/*
 * Decompiled with CFR 0.152.
 */
package com.bin.david.form.component;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import com.bin.david.form.core.TableConfig;
import com.bin.david.form.data.Cell;
import com.bin.david.form.data.CellRange;
import com.bin.david.form.data.Column;
import com.bin.david.form.data.table.TableData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GridDrawer<T> {
    private Path path = new Path();
    private ArrayList<Integer> horizontalGrids;
    private ArrayList<Integer> verticalGrids;
    private Set<Integer> clipVerticalSet;
    private Rect tableShowRect = new Rect();
    private int hMinPosition;
    private int hMaxPosition;
    private int vMinPosition;
    private int vMaxPosition;
    private boolean isHasHData;
    private boolean isHasVData;
    private List<CellRange> cellRanges;
    private Set<Integer> set;
    private TableData<T> tableData;
    private Cell[][] rangePoints;

    public GridDrawer() {
        this.horizontalGrids = new ArrayList();
        this.verticalGrids = new ArrayList();
        this.clipVerticalSet = new HashSet<Integer>();
        this.set = new HashSet<Integer>();
    }

    public void reset() {
        this.horizontalGrids.clear();
        this.verticalGrids.clear();
        this.clipVerticalSet.clear();
        this.tableShowRect.set(-1, -1, -1, -1);
        this.isHasHData = false;
        this.isHasVData = false;
        this.set.clear();
    }

    public void addHorizontalGrid(int position, int left, int right, int y) {
        if (!this.isHasHData) {
            this.tableShowRect.left = left;
            this.tableShowRect.right = right;
            this.hMinPosition = position;
            this.hMaxPosition = position;
            this.isHasHData = true;
        } else {
            this.hMaxPosition = position;
        }
        this.horizontalGrids.add(y);
    }

    public void addVerticalGrid(int position, int top, int bottom, int x, boolean isClip) {
        if (!this.isHasVData) {
            this.tableShowRect.top = top;
            this.tableShowRect.bottom = bottom;
            this.vMinPosition = position;
            this.vMaxPosition = position;
            this.isHasVData = true;
        } else {
            this.vMaxPosition = position;
        }
        this.verticalGrids.add(x);
        if (isClip) {
            this.clipVerticalSet.add(position);
        }
    }

    public void drawGrid(Canvas canvas, TableConfig config) {
        Paint paint = config.getPaint();
        this.drawHGrid(canvas, paint);
        this.drawVGrid(canvas, paint);
    }

    private void drawHGrid(Canvas canvas, Paint paint) {
        if (this.cellRanges == null || this.cellRanges.size() == 0) {
            for (int hGrid : this.horizontalGrids) {
                this.path.rewind();
                this.path.moveTo((float)this.tableShowRect.left, (float)hGrid);
                this.path.lineTo((float)this.tableShowRect.right, (float)hGrid);
                canvas.drawPath(this.path, paint);
            }
        } else {
            for (int k = 0; k < this.horizontalGrids.size(); ++k) {
                int hGrid = this.horizontalGrids.get(k);
                int currentPosition = k + this.hMinPosition;
                this.path.rewind();
                this.path.moveTo((float)this.tableShowRect.left, (float)hGrid);
                boolean isLineTo = false;
                this.set.clear();
                for (CellRange address : this.cellRanges) {
                    if (address.getLastRow() <= currentPosition || address.getFirstRow() > currentPosition || address.getLastCol() < this.vMinPosition - 1 && address.getFirstCol() > this.vMaxPosition + 1) continue;
                    for (int i = address.getFirstCol(); i <= address.getLastCol(); ++i) {
                        this.set.add(i);
                    }
                }
                if (this.set.size() > 0) {
                    for (int i = this.vMinPosition; i <= this.vMaxPosition; ++i) {
                        if (this.set.contains(i)) {
                            if (isLineTo) continue;
                            this.path.lineTo((float)this.verticalGrids.get(i - this.vMinPosition).intValue(), (float)hGrid);
                            isLineTo = true;
                            continue;
                        }
                        if (!isLineTo) continue;
                        this.path.moveTo((float)this.verticalGrids.get(i - this.vMinPosition).intValue(), (float)hGrid);
                        isLineTo = false;
                    }
                }
                if (!isLineTo) {
                    this.path.lineTo((float)this.tableShowRect.right, (float)hGrid);
                }
                canvas.drawPath(this.path, paint);
            }
        }
    }

    private void drawVGrid(Canvas canvas, Paint paint) {
        if (this.cellRanges == null || this.cellRanges.size() == 0) {
            int k = 0;
            for (int vGrid : this.verticalGrids) {
                int currentPosition = k + this.vMinPosition - 1;
                if (!this.clipVerticalSet.contains(currentPosition + 1)) {
                    this.path.rewind();
                    this.path.moveTo((float)vGrid, (float)this.tableShowRect.top);
                    this.path.lineTo((float)vGrid, (float)this.tableShowRect.bottom);
                    canvas.drawPath(this.path, paint);
                }
                ++k;
            }
        } else {
            for (int k = 0; k < this.verticalGrids.size(); ++k) {
                int currentPosition = k + this.vMinPosition - 1;
                if (this.clipVerticalSet.contains(currentPosition + 1)) continue;
                int vGrid = this.verticalGrids.get(k);
                this.path.rewind();
                this.path.moveTo((float)vGrid, (float)this.tableShowRect.top);
                boolean isLineTo = false;
                this.set.clear();
                for (CellRange address : this.cellRanges) {
                    if (address.getLastCol() <= currentPosition || address.getFirstCol() > currentPosition || address.getLastRow() < this.hMinPosition - 1 && address.getFirstRow() > this.hMaxPosition + 1) continue;
                    for (int i = address.getFirstRow(); i <= address.getLastRow(); ++i) {
                        this.set.add(i);
                    }
                }
                if (this.set.size() > 0) {
                    for (int i = this.hMinPosition; i <= this.hMaxPosition; ++i) {
                        if (this.set.contains(i) && i - this.hMinPosition - 1 >= 0) {
                            if (isLineTo) continue;
                            this.path.lineTo((float)vGrid, (float)this.horizontalGrids.get(i - this.hMinPosition - 1).intValue());
                            isLineTo = true;
                            continue;
                        }
                        if (!isLineTo || i - this.hMinPosition - 1 < 0) continue;
                        this.path.moveTo((float)vGrid, (float)this.horizontalGrids.get(i - this.hMinPosition - 1).intValue());
                        isLineTo = false;
                    }
                }
                if (!isLineTo) {
                    this.path.lineTo((float)vGrid, (float)this.tableShowRect.bottom);
                }
                canvas.drawPath(this.path, paint);
            }
        }
    }

    public void setTableData(TableData<T> tableData) {
        this.tableData = tableData;
        this.cellRanges = tableData.getCellRangeAddresses();
        this.rangePoints = tableData.getTableInfo().getRangeCells();
    }

    public Rect correctCellRect(int row, int col, Rect rect, float zoom) {
        Cell point = this.rangePoints[row][col];
        if (point != null) {
            if (point.col != -1 && point.row != -1) {
                int i;
                List<Column> childColumns = this.tableData.getChildColumns();
                int[] lineHeights = this.tableData.getTableInfo().getLineHeightArray();
                int width = 0;
                int height = 0;
                for (i = col; i < Math.min(childColumns.size(), col + point.col); ++i) {
                    width = (int)((float)width + (float)childColumns.get(i).getWidth() * zoom);
                }
                for (i = row; i < Math.min(lineHeights.length, row + point.row); ++i) {
                    height = (int)((float)height + (float)lineHeights[i] * zoom);
                }
                rect.right = rect.left + width;
                rect.bottom = rect.top + height;
                return rect;
            }
            return null;
        }
        return rect;
    }

    public boolean maybeContain(double row, double col) {
        return row > (double)(this.hMinPosition - 1) && row < (double)(this.hMaxPosition + 1) && col > (double)(this.vMinPosition - 1) && col < (double)(this.vMaxPosition + 1);
    }
}

