/*
 * Decompiled with CFR 0.152.
 */
package com.bin.david.form.component;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import com.bin.david.form.component.GridDrawer;
import com.bin.david.form.component.SelectionOperation;
import com.bin.david.form.core.TableConfig;
import com.bin.david.form.data.Column;
import com.bin.david.form.data.ColumnInfo;
import com.bin.david.form.data.TableInfo;
import com.bin.david.form.data.format.bg.ICellBackgroundFormat;
import com.bin.david.form.data.format.selected.IDrawOver;
import com.bin.david.form.data.format.selected.ISelectFormat;
import com.bin.david.form.data.format.tip.ITip;
import com.bin.david.form.data.table.TableData;
import com.bin.david.form.listener.OnColumnClickListener;
import com.bin.david.form.listener.TableClickObserver;
import com.bin.david.form.utils.DrawUtils;
import java.util.List;

public class TableProvider<T>
implements TableClickObserver {
    private Rect scaleRect;
    private Rect showRect;
    private TableConfig config;
    private PointF clickPoint;
    private ColumnInfo clickColumnInfo;
    private boolean isClickPoint;
    private OnColumnClickListener onColumnClickListener;
    private SelectionOperation operation;
    private TableData<T> tableData;
    private ITip<Column, ?> tip;
    private Rect clipRect;
    private Rect tempRect;
    private Column tipColumn;
    private int tipPosition;
    private GridDrawer<T> gridDrawer;
    private PointF tipPoint = new PointF();
    private IDrawOver drawOver;

    public TableProvider() {
        this.clickPoint = new PointF(-1.0f, -1.0f);
        this.clipRect = new Rect();
        this.tempRect = new Rect();
        this.operation = new SelectionOperation();
        this.gridDrawer = new GridDrawer();
    }

    public void onDraw(Canvas canvas, Rect scaleRect, Rect showRect, TableData<T> tableData, TableConfig config) {
        this.setData(scaleRect, showRect, tableData, config);
        canvas.save();
        canvas.clipRect(this.showRect);
        this.drawColumnTitle(canvas, config);
        this.drawCount(canvas);
        this.drawContent(canvas);
        this.operation.draw(canvas, showRect, config);
        if (this.drawOver != null) {
            this.drawOver.draw(canvas, scaleRect, showRect, config);
        }
        canvas.restore();
        if (this.isClickPoint && this.clickColumnInfo != null) {
            this.onColumnClickListener.onClick(this.clickColumnInfo);
        }
        if (this.tipColumn != null) {
            this.drawTip(canvas, this.tipPoint.x, this.tipPoint.y, this.tipColumn, this.tipPosition);
        }
    }

    private void setData(Rect scaleRect, Rect showRect, TableData<T> tableData, TableConfig config) {
        this.isClickPoint = false;
        this.clickColumnInfo = null;
        this.tipColumn = null;
        this.gridDrawer.reset();
        this.operation.reset();
        this.scaleRect = scaleRect;
        this.showRect = showRect;
        this.config = config;
        this.tableData = tableData;
        this.gridDrawer.setTableData(tableData);
    }

    private void drawColumnTitle(Canvas canvas, TableConfig config) {
        if (config.isShowColumnTitle()) {
            if (config.isFixedTitle()) {
                this.drawTitle(canvas);
                canvas.restore();
                canvas.save();
                canvas.clipRect(this.showRect);
            } else {
                this.drawTitle(canvas);
            }
        }
    }

    private void drawCount(Canvas canvas) {
        if (this.tableData.isShowCount()) {
            float left = this.scaleRect.left;
            float bottom = this.config.isFixedCountRow() ? (float)Math.min(this.scaleRect.bottom, this.showRect.bottom) : (float)this.scaleRect.bottom;
            int countHeight = this.tableData.getTableInfo().getCountHeight();
            float top = bottom - (float)countHeight;
            int backgroundColor = this.config.getCountBackgroundColor();
            if (backgroundColor != 0) {
                DrawUtils.fillBackground(canvas, (int)left, (int)top, this.showRect.right, (int)bottom, backgroundColor, this.config.getPaint());
            }
            List<ColumnInfo> childColumnInfos = this.tableData.getChildColumnInfos();
            if (DrawUtils.isVerticalMixRect(this.showRect, (int)top, (int)bottom)) {
                int i;
                List<Column> columns = this.tableData.getChildColumns();
                int columnSize = columns.size();
                boolean isPerColumnFixed = false;
                this.clipRect.set(this.showRect);
                int clipCount = 0;
                for (i = 0; i < columnSize; ++i) {
                    Column column = columns.get(i);
                    float tempLeft = left;
                    float width = (float)column.getWidth() * this.config.getZoom();
                    if (childColumnInfos.get((int)i).getTopParent().column.isFixed()) {
                        if (left < (float)this.clipRect.left) {
                            left = this.clipRect.left;
                            this.clipRect.left = (int)((float)this.clipRect.left + width);
                            isPerColumnFixed = true;
                        }
                    } else if (isPerColumnFixed) {
                        canvas.save();
                        ++clipCount;
                        canvas.clipRect(this.clipRect.left, this.showRect.bottom - countHeight, this.showRect.right, this.showRect.bottom);
                    }
                    this.tempRect.set((int)left, (int)top, (int)(left + width), (int)bottom);
                    this.drawCountText(canvas, column, this.tempRect, column.getTotalNumString(), this.config);
                    left = tempLeft;
                    left += width;
                }
                for (i = 0; i < clipCount; ++i) {
                    canvas.restore();
                }
            }
        }
    }

    private void drawTitle(Canvas canvas) {
        int dis = this.showRect.top - this.scaleRect.top;
        TableInfo tableInfo = this.tableData.getTableInfo();
        int titleHeight = tableInfo.getTitleHeight() * tableInfo.getMaxLevel();
        int clipHeight = this.config.isFixedTitle() ? titleHeight : Math.max(0, titleHeight - dis);
        DrawUtils.fillBackground(canvas, this.showRect.left, this.showRect.top, this.showRect.right, this.showRect.top + clipHeight, this.config.getColumnTitleBackgroundColor(), this.config.getPaint());
        this.clipRect.set(this.showRect);
        List<ColumnInfo> columnInfoList = this.tableData.getColumnInfos();
        float zoom = this.config.getZoom();
        boolean isPerColumnFixed = false;
        int clipCount = 0;
        ColumnInfo parentColumnInfo = null;
        for (ColumnInfo info : columnInfoList) {
            int left = (int)((float)info.left * zoom + (float)this.scaleRect.left);
            if (info.top == 0 && info.column.isFixed()) {
                if (left < this.clipRect.left) {
                    parentColumnInfo = info;
                    left = this.clipRect.left;
                    this.fillColumnTitle(canvas, info, left);
                    this.clipRect.left = (int)((float)this.clipRect.left + (float)info.width * zoom);
                    isPerColumnFixed = true;
                    continue;
                }
            } else if (isPerColumnFixed && info.top != 0) {
                left = (int)((float)this.clipRect.left - (float)info.width * zoom);
                left += info.left - parentColumnInfo.left;
            } else if (isPerColumnFixed) {
                canvas.save();
                canvas.clipRect(this.clipRect.left, this.showRect.top, this.showRect.right, this.showRect.top + clipHeight);
                isPerColumnFixed = false;
                ++clipCount;
            }
            this.fillColumnTitle(canvas, info, left);
        }
        for (int i = 0; i < clipCount; ++i) {
            canvas.restore();
        }
        if (this.config.isFixedTitle()) {
            this.scaleRect.top += titleHeight;
            this.showRect.top += titleHeight;
        } else {
            this.showRect.top += clipHeight;
            this.scaleRect.top += titleHeight;
        }
    }

    private void fillColumnTitle(Canvas canvas, ColumnInfo info, int left) {
        int bottom;
        int right;
        int top = (int)((float)info.top * this.config.getZoom()) + (this.config.isFixedTitle() ? this.showRect.top : this.scaleRect.top);
        if (DrawUtils.isMixRect(this.showRect, left, top, right = (int)((float)left + (float)info.width * this.config.getZoom()), bottom = (int)((float)top + (float)info.height * this.config.getZoom()))) {
            if (!this.isClickPoint && this.onColumnClickListener != null && DrawUtils.isClick(left, top, right, bottom, this.clickPoint)) {
                this.isClickPoint = true;
                this.clickColumnInfo = info;
                this.clickPoint.set(-1.0f, -1.0f);
            }
            Paint paint = this.config.getPaint();
            this.tempRect.set(left, top, right, bottom);
            this.tableData.getTitleDrawFormat().draw(canvas, info.column, this.tempRect, this.config);
            this.config.getColumnTitleGridStyle().fillPaint(paint);
            canvas.drawRect((float)left, (float)top, (float)right, (float)bottom, paint);
        }
    }

    private void drawContent(Canvas canvas) {
        int i;
        float left = this.scaleRect.left;
        Paint paint = this.config.getPaint();
        List<Column> columns = this.tableData.getChildColumns();
        this.clipRect.set(this.showRect);
        TableInfo info = this.tableData.getTableInfo();
        int columnSize = columns.size();
        int dis = this.config.isFixedCountRow() ? info.getCountHeight() : this.showRect.bottom + info.getCountHeight() - this.scaleRect.bottom;
        int fillBgBottom = this.showRect.bottom - Math.max(dis, 0);
        DrawUtils.fillBackground(canvas, this.showRect.left, this.showRect.top, this.showRect.right, fillBgBottom, this.config.getContentBackgroundColor(), this.config.getPaint());
        if (this.config.isFixedCountRow()) {
            canvas.save();
            canvas.clipRect(this.showRect.left, this.showRect.top, this.showRect.right, this.showRect.bottom - info.getCountHeight());
        }
        List<ColumnInfo> childColumnInfo = this.tableData.getChildColumnInfos();
        boolean isPerFixed = false;
        int clipCount = 0;
        for (i = 0; i < columnSize; ++i) {
            float top = this.scaleRect.top;
            Column column = columns.get(i);
            float width = (float)column.getWidth() * this.config.getZoom();
            float tempLeft = left;
            Column topColumn = childColumnInfo.get((int)i).getTopParent().column;
            if (topColumn.isFixed()) {
                isPerFixed = false;
                if (tempLeft < (float)this.clipRect.left) {
                    left = this.clipRect.left;
                    this.clipRect.left = (int)((float)this.clipRect.left + width);
                    isPerFixed = true;
                }
            } else if (isPerFixed) {
                canvas.save();
                canvas.clipRect(this.clipRect);
                isPerFixed = false;
                ++clipCount;
            }
            float right = left + width;
            if (!(left < (float)this.showRect.right)) break;
            int size = column.getDatas().size();
            for (int j = 0; j < size; ++j) {
                String value = column.format(j);
                float bottom = top + (float)info.getLineHeightArray()[j] * this.config.getZoom();
                this.tempRect.set((int)left, (int)top, (int)right, (int)bottom);
                Rect correctCellRect = this.gridDrawer.correctCellRect(j, i, this.tempRect, this.config.getZoom());
                if (correctCellRect != null) {
                    if (correctCellRect.top >= this.showRect.bottom) break;
                    if (correctCellRect.right > this.showRect.left && correctCellRect.bottom > this.showRect.top) {
                        Object data = column.getDatas().get(j);
                        if (DrawUtils.isClick(correctCellRect, this.clickPoint)) {
                            this.operation.setSelectionRect(i, j, correctCellRect);
                            this.tipPoint.x = (left + right) / 2.0f;
                            this.tipPoint.y = (top + bottom) / 2.0f;
                            this.tipColumn = column;
                            this.tipPosition = j;
                            this.clickColumn(column, j, value, data);
                            this.isClickPoint = true;
                            this.clickPoint.set(-2.1474836E9f, -2.1474836E9f);
                        }
                        this.operation.checkSelectedPoint(i, j, correctCellRect);
                        this.config.getContentStyle().fillPaint(paint);
                        column.getDrawFormat().draw(canvas, column, data, value, correctCellRect, j, this.config);
                    }
                }
                if (i == 0) {
                    this.gridDrawer.addHorizontalGrid(j, Math.max(this.scaleRect.left, this.showRect.left), Math.min(this.scaleRect.right, this.showRect.right), (int)bottom);
                }
                top = bottom;
            }
            this.config.getGridStyle().fillPaint(paint);
            this.gridDrawer.addVerticalGrid(i, Math.max(this.scaleRect.top, this.showRect.top), Math.min(this.showRect.bottom, this.scaleRect.bottom), isPerFixed ? this.clipRect.left : (int)left, !topColumn.isFixed() && left < (float)this.clipRect.left);
            left = tempLeft + width;
        }
        for (i = 0; i < clipCount; ++i) {
            canvas.restore();
        }
        this.gridDrawer.drawGrid(canvas, this.config);
        if (this.config.isFixedCountRow()) {
            canvas.restore();
        }
    }

    private void clickColumn(Column column, int position, String value, Object data) {
        if (!this.isClickPoint && column.getOnColumnItemClickListener() != null) {
            column.getOnColumnItemClickListener().onClick(column, value, data, position);
        }
    }

    void drawTip(Canvas canvas, float x, float y, Column c, int position) {
        if (this.tip != null) {
            this.tip.drawTip(canvas, x, y, this.showRect, c, position);
        }
    }

    private void drawCountText(Canvas canvas, Column column, Rect rect, String text, TableConfig config) {
        Paint paint = config.getPaint();
        ICellBackgroundFormat<Column> backgroundFormat = config.getCountBgFormat();
        if (backgroundFormat != null) {
            backgroundFormat.drawBackground(canvas, rect, column, config.getPaint());
        }
        config.getGridStyle().fillPaint(paint);
        canvas.drawRect(rect, paint);
        config.getCountStyle().fillPaint(paint);
        if (backgroundFormat != null && backgroundFormat.getTextColor(column) != 0) {
            paint.setColor(backgroundFormat.getTextColor(column));
        }
        paint.setTextSize(paint.getTextSize() * config.getZoom());
        if (column.getTextAlign() != null) {
            paint.setTextAlign(column.getTextAlign());
        }
        canvas.drawText(text, DrawUtils.getTextCenterX(rect.left, rect.right, paint), DrawUtils.getTextCenterY(rect.centerY(), paint), paint);
    }

    @Override
    public void onClick(float x, float y) {
        this.clickPoint.x = x;
        this.clickPoint.y = y;
    }

    public OnColumnClickListener getOnColumnClickListener() {
        return this.onColumnClickListener;
    }

    public void setOnColumnClickListener(OnColumnClickListener onColumnClickListener) {
        this.onColumnClickListener = onColumnClickListener;
    }

    public ITip<Column, ?> getTip() {
        return this.tip;
    }

    public void setTip(ITip<Column, ?> tip) {
        this.tip = tip;
    }

    public void setSelectFormat(ISelectFormat selectFormat) {
        this.operation.setSelectFormat(selectFormat);
    }

    public GridDrawer<T> getGridDrawer() {
        return this.gridDrawer;
    }

    public void setGridDrawer(GridDrawer<T> gridDrawer) {
        this.gridDrawer = gridDrawer;
    }

    public int[] getPointLocation(double row, double col) {
        List<Column> childColumns = this.tableData.getChildColumns();
        int[] lineHeights = this.tableData.getTableInfo().getLineHeightArray();
        int x = 0;
        int y = 0;
        int columnSize = childColumns.size();
        int i = 0;
        while (true) {
            double d = i;
            double d2 = (double)columnSize > col + 1.0 ? col + 1.0 : (double)(columnSize - 1);
            if (!(d <= d2)) break;
            int w = childColumns.get(i).getWidth();
            x = i == (int)col + 1 ? (int)((double)x + (double)w * (col - (double)((int)col))) : (x += w);
            ++i;
        }
        i = 0;
        while (true) {
            double d = i;
            double d3 = (double)lineHeights.length > row + 1.0 ? row + 1.0 : (double)(lineHeights.length - 1);
            if (!(d <= d3)) break;
            int h = lineHeights[i];
            y = i == (int)row + 1 ? (int)((double)y + (double)h * (row - (double)((int)row))) : (y += h);
            ++i;
        }
        x = (int)((float)x * this.config.getZoom());
        y = (int)((float)y * this.config.getZoom());
        return new int[]{x += this.scaleRect.left, y += this.scaleRect.top};
    }

    public int[] getPointSize(int row, int col) {
        List<Column> childColumns = this.tableData.getChildColumns();
        int[] lineHeights = this.tableData.getTableInfo().getLineHeightArray();
        col = col < childColumns.size() ? col : childColumns.size() - 1;
        row = row < lineHeights.length ? row : lineHeights.length;
        return new int[]{(int)((float)childColumns.get(col).getWidth() * this.config.getZoom()), (int)((float)lineHeights[row] * this.config.getZoom())};
    }

    public void setDrawOver(IDrawOver drawOver) {
        this.drawOver = drawOver;
    }

    public SelectionOperation getOperation() {
        return this.operation;
    }
}

