/*
 * Decompiled with CFR 0.152.
 */
package com.bin.david.form.core;

import com.bin.david.form.annotation.ColumnType;
import com.bin.david.form.annotation.FieldGenericHandler;
import com.bin.david.form.annotation.SmartColumn;
import com.bin.david.form.annotation.SmartTable;
import com.bin.david.form.data.Column;
import com.bin.david.form.data.table.PageTableData;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AnnotationParser<T> {
    public PageTableData<T> parse(List<T> dataList) {
        Class<?> clazz;
        SmartTable tableAnnotation;
        T firstData;
        if (dataList != null && dataList.size() > 0 && (firstData = dataList.get(0)) != null && (tableAnnotation = (clazz = firstData.getClass()).getAnnotation(SmartTable.class)) != null) {
            SmartTable table = tableAnnotation;
            ArrayList<Column> columns = new ArrayList<Column>();
            PageTableData<T> tableData = new PageTableData<T>(table.name(), dataList, columns);
            tableData.setCurrentPage(table.currentPage());
            tableData.setPageSize(table.pageSize());
            tableData.setShowCount(table.count());
            FieldGenericHandler genericHandler = new FieldGenericHandler();
            HashMap<String, Column> parentMap = new HashMap<String, Column>();
            this.getColumnAnnotation(clazz, null, columns, genericHandler, parentMap);
            Collections.sort(columns);
            return tableData;
        }
        return null;
    }

    private void getColumnAnnotation(Class clazz, String parentFieldName, List<Column> columns, FieldGenericHandler genericHandler, Map<String, Column> parentMap) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            field.setAccessible(true);
            Class<?> fieldClass = field.getType();
            SmartColumn fieldAnnotation = field.getAnnotation(SmartColumn.class);
            if (fieldAnnotation == null) continue;
            SmartColumn smartColumn = fieldAnnotation;
            ColumnType type = smartColumn.type();
            if (type == ColumnType.Own) {
                String name = smartColumn.name();
                int id = smartColumn.id();
                String parent = smartColumn.parent();
                boolean isAutoCount = smartColumn.autoCount();
                if (name.equals("")) {
                    name = field.getName();
                }
                String fieldName = parentFieldName != null ? parentFieldName + field.getName() : field.getName();
                Column<?> column = genericHandler.getGenericColumn(fieldClass, name, fieldName);
                column.setId(id);
                column.setTextAlign(smartColumn.align());
                column.setAutoMerge(smartColumn.autoMerge());
                if (smartColumn.maxMergeCount() != -1) {
                    column.setMaxMergeCount(smartColumn.maxMergeCount());
                }
                column.setAutoCount(isAutoCount);
                column.setFixed(smartColumn.fixed());
                if (!parent.equals("")) {
                    Column parentColumn = parentMap.get(parent);
                    if (parentColumn == null) {
                        ArrayList<Column> childColumns = new ArrayList<Column>();
                        childColumns.add(column);
                        parentColumn = new Column(parent, childColumns);
                        parentColumn.setId(id);
                        columns.add(parentColumn);
                        parentMap.put(parent, parentColumn);
                    }
                    parentColumn.addChildren(column);
                    if (id >= parentColumn.getId()) continue;
                    parentColumn.setId(id);
                    continue;
                }
                columns.add(column);
                continue;
            }
            if (type != ColumnType.Child) continue;
            String fieldName = (parentFieldName != null ? parentFieldName : "") + field.getName() + ".";
            this.getColumnAnnotation(fieldClass, fieldName, columns, genericHandler, parentMap);
        }
    }
}

