/*
 * Decompiled with CFR 0.152.
 */
package com.bin.david.form.core;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.bin.david.form.component.ITableTitle;
import com.bin.david.form.component.TableProvider;
import com.bin.david.form.component.TableTitle;
import com.bin.david.form.component.XSequence;
import com.bin.david.form.component.YSequence;
import com.bin.david.form.core.AnnotationParser;
import com.bin.david.form.core.TableConfig;
import com.bin.david.form.core.TableMeasurer;
import com.bin.david.form.core.TableParser;
import com.bin.david.form.data.Column;
import com.bin.david.form.data.TableInfo;
import com.bin.david.form.data.format.selected.ISelectFormat;
import com.bin.david.form.data.style.FontStyle;
import com.bin.david.form.data.table.PageTableData;
import com.bin.david.form.data.table.TableData;
import com.bin.david.form.listener.OnColumnClickListener;
import com.bin.david.form.listener.OnTableChangeListener;
import com.bin.david.form.matrix.MatrixHelper;
import java.util.List;

public class SmartTable<T>
extends View
implements OnTableChangeListener {
    private XSequence<T> xAxis;
    private YSequence<T> yAxis;
    private ITableTitle tableTitle;
    private TableProvider<T> provider;
    private Rect showRect;
    private Rect tableRect;
    private TableConfig config;
    private TableParser<T> parser;
    private TableData<T> tableData;
    private TableMeasurer<T> measurer;
    private AnnotationParser<T> annotationParser;
    protected Paint paint;
    private MatrixHelper matrixHelper;
    private Object lockObject = new Object();

    public SmartTable(Context context) {
        super(context);
        this.init();
    }

    public SmartTable(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public SmartTable(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        FontStyle.setDefaultTextSpSize(this.getContext(), 13);
        this.paint = new Paint(1);
        this.showRect = new Rect();
        this.tableRect = new Rect();
        this.config = new TableConfig();
        this.xAxis = new XSequence();
        this.yAxis = new YSequence();
        this.parser = new TableParser();
        this.provider = new TableProvider();
        this.config.setPaint(this.paint);
        this.measurer = new TableMeasurer();
        this.tableTitle = new TableTitle();
        this.tableTitle.setDirection(1);
        this.matrixHelper = new MatrixHelper(this.getContext());
        this.matrixHelper.setOnTableChangeListener(this);
        this.matrixHelper.register(this.provider);
        this.matrixHelper.setOnInterceptListener(this.provider.getOperation());
    }

    protected void onDraw(Canvas canvas) {
        Rect rect;
        this.setScrollY(0);
        this.showRect.set(0, 0, this.getWidth(), this.getHeight());
        if (this.tableData != null && (rect = this.tableData.getTableInfo().getTableRect()) != null) {
            if (this.config.isShowTableTitle()) {
                this.measurer.measureTableTitle(this.tableData, this.tableTitle, this.showRect);
            }
            this.tableRect.set(rect);
            Rect scaleRect = this.matrixHelper.getZoomProviderRect(this.showRect, this.tableRect, this.tableData.getTableInfo());
            if (this.config.isShowTableTitle()) {
                this.tableTitle.onMeasure(scaleRect, this.showRect, this.config);
                this.tableTitle.onDraw(canvas, this.showRect, this.tableData.getTableName(), this.config);
            }
            this.drawGridBackground(canvas, this.showRect, scaleRect);
            if (this.config.isShowYSequence()) {
                this.yAxis.onMeasure(scaleRect, this.showRect, this.config);
                this.yAxis.onDraw(canvas, this.showRect, this.tableData, this.config);
            }
            if (this.config.isShowXSequence()) {
                this.xAxis.onMeasure(scaleRect, this.showRect, this.config);
                this.xAxis.onDraw(canvas, this.showRect, this.tableData, this.config);
            }
            this.provider.onDraw(canvas, scaleRect, this.showRect, this.tableData, this.config);
        }
    }

    private void drawGridBackground(Canvas canvas, Rect showRect, Rect scaleRect) {
        this.config.getGridStyle().fillPaint(this.paint);
        canvas.drawRect((float)showRect.left, (float)showRect.top, (float)showRect.right, (float)Math.min(scaleRect.bottom, showRect.bottom), this.paint);
    }

    public TableConfig getConfig() {
        return this.config;
    }

    public PageTableData<T> setData(List<T> data) {
        PageTableData<T> tableData;
        if (this.annotationParser == null) {
            this.annotationParser = new AnnotationParser();
        }
        if ((tableData = this.annotationParser.parse(data)) != null) {
            this.setTableData(tableData);
        }
        return tableData;
    }

    public void setTableData(TableData<T> tableData) {
        this.tableData = tableData;
        this.notifyDataChanged();
    }

    public ITableTitle getTableTitle() {
        return this.tableTitle;
    }

    public void notifyDataChanged() {
        if (this.tableData != null) {
            this.config.setPaint(this.paint);
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = SmartTable.this.lockObject;
                    synchronized (object) {
                        SmartTable.this.parser.parse(SmartTable.this.tableData, SmartTable.this.config);
                        TableInfo info = SmartTable.this.measurer.measure(SmartTable.this.tableData, SmartTable.this.config);
                        SmartTable.this.xAxis.setHeight(info.getTopHeight());
                        SmartTable.this.yAxis.setWidth(info.getyAxisWidth());
                        SmartTable.this.postInvalidate();
                    }
                }
            }).start();
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        return this.matrixHelper.handlerTouchEvent(event);
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        this.matrixHelper.onDisallowInterceptEvent(this, event);
        return super.dispatchTouchEvent(event);
    }

    @Override
    public void onTableChanged(float scale, float translateX, float translateY) {
        if (this.tableData != null) {
            this.config.setZoom(scale);
            this.tableData.getTableInfo().setZoom(scale);
            this.invalidate();
        }
    }

    public OnColumnClickListener getOnColumnClickListener() {
        return this.provider.getOnColumnClickListener();
    }

    public void setOnColumnClickListener(OnColumnClickListener onColumnClickListener) {
        this.provider.setOnColumnClickListener(onColumnClickListener);
    }

    public void setSortColumn(Column column, boolean isReverse) {
        if (this.tableData != null && column != null) {
            column.setReverseSort(isReverse);
            this.tableData.setSortColumn(column);
            this.setTableData(this.tableData);
        }
    }

    public Rect getShowRect() {
        return this.showRect;
    }

    public TableProvider<T> getProvider() {
        return this.provider;
    }

    public TableData<T> getTableData() {
        return this.tableData;
    }

    public void setZoom(boolean zoom) {
        this.matrixHelper.setCanZoom(zoom);
        this.invalidate();
    }

    public void setZoom(boolean zoom, float maxZoom, float minZoom) {
        this.matrixHelper.setCanZoom(zoom);
        this.matrixHelper.setMinZoom(minZoom);
        this.matrixHelper.setMaxZoom(maxZoom);
        this.invalidate();
    }

    public MatrixHelper getMatrixHelper() {
        return this.matrixHelper;
    }

    public void addData(List<T> t, boolean isFoot) {
        if (t != null && t.size() > 0) {
            int size = this.tableData.getLineSize();
            this.parser.addData(this.tableData, t, isFoot, this.config);
            this.measurer.addTableHeight(this.tableData, size);
        }
        this.invalidate();
    }

    public void setSelectFormat(ISelectFormat selectFormat) {
        this.provider.setSelectFormat(selectFormat);
    }

    public int computeHorizontalScrollRange() {
        int contentWidth = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        int scrollRange = this.matrixHelper.getZoomRect().right;
        int scrollX = -this.matrixHelper.getZoomRect().right;
        int overScrollRight = Math.max(0, scrollRange - contentWidth);
        if (scrollX < 0) {
            scrollRange -= scrollX;
        } else if (scrollX > overScrollRight) {
            scrollRange += scrollX - overScrollRight;
        }
        return scrollRange;
    }

    public boolean canScrollVertically(int direction) {
        if (direction < 0) {
            return this.matrixHelper.getZoomRect().top != 0;
        }
        return this.matrixHelper.getZoomRect().bottom > this.matrixHelper.getOriginalRect().bottom;
    }

    public int computeHorizontalScrollOffset() {
        return Math.max(0, -this.matrixHelper.getZoomRect().top);
    }

    public int computeHorizontalScrollExtent() {
        return super.computeHorizontalScrollExtent();
    }

    public int computeVerticalScrollRange() {
        int contentHeight = this.getHeight() - this.getPaddingBottom() - this.getPaddingTop();
        int scrollRange = this.matrixHelper.getZoomRect().bottom;
        int scrollY = -this.matrixHelper.getZoomRect().left;
        int overScrollBottom = Math.max(0, scrollRange - contentHeight);
        if (scrollY < 0) {
            scrollRange -= scrollY;
        } else if (scrollY > overScrollBottom) {
            scrollRange += scrollY - overScrollBottom;
        }
        return scrollRange;
    }

    public int computeVerticalScrollOffset() {
        return Math.max(0, -this.matrixHelper.getZoomRect().left);
    }

    public int computeVerticalScrollExtent() {
        return super.computeVerticalScrollExtent();
    }

    public XSequence<T> getXSequence() {
        return this.xAxis;
    }

    public YSequence getYSequence() {
        return this.yAxis;
    }

    protected void onDetachedFromWindow() {
        this.matrixHelper.unRegisterAll();
        this.provider = null;
        if (this.tableData != null) {
            this.tableData.clear();
            this.tableData = null;
        }
        this.xAxis = null;
        this.yAxis = null;
        super.onDetachedFromWindow();
    }
}

