/*
 * Decompiled with CFR 0.152.
 */
package com.bin.david.form.data;

import android.graphics.Paint;
import com.bin.david.form.core.TableConfig;
import com.bin.david.form.data.TableInfo;
import com.bin.david.form.data.format.IFormat;
import com.bin.david.form.data.format.count.DecimalCountFormat;
import com.bin.david.form.data.format.count.ICountFormat;
import com.bin.david.form.data.format.count.NumberCountFormat;
import com.bin.david.form.data.format.count.StringCountFormat;
import com.bin.david.form.data.format.draw.IDrawFormat;
import com.bin.david.form.data.format.draw.TextDrawFormat;
import com.bin.david.form.listener.OnColumnItemClickListener;
import com.bin.david.form.utils.LetterUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class Column<T>
implements Comparable<Column> {
    private String columnName;
    private List<Column> children;
    private IFormat<T> format;
    private IDrawFormat<T> drawFormat;
    private String fieldName;
    private List<T> datas;
    private boolean isFixed;
    private int width;
    private int level;
    private Comparator<T> comparator;
    private ICountFormat<T, ? extends Number> countFormat;
    private boolean isReverseSort;
    private OnColumnItemClickListener<T> onColumnItemClickListener;
    private Paint.Align textAlign;
    private boolean isAutoCount = false;
    private boolean isAutoMerge = false;
    private int maxMergeCount = Integer.MAX_VALUE;
    private int id;
    private boolean isParent;
    private List<int[]> ranges;

    public Column(String columnName, List<Column> children) {
        this.columnName = columnName;
        this.children = children;
        this.isParent = true;
    }

    public Column(String columnName, Column ... children) {
        this(columnName, Arrays.asList(children));
    }

    public Column(String columnName, String fieldName) {
        this(columnName, fieldName, null, null);
    }

    public Column(String columnName, String fieldName, IFormat<T> format) {
        this(columnName, fieldName, format, null);
    }

    public Column(String columnName, String fieldName, IDrawFormat<T> drawFormat) {
        this(columnName, fieldName, null, drawFormat);
    }

    public Column(String columnName, String fieldName, IFormat<T> format, IDrawFormat<T> drawFormat) {
        this.columnName = columnName;
        this.format = format;
        this.fieldName = fieldName;
        this.drawFormat = drawFormat == null ? new TextDrawFormat() : drawFormat;
        this.datas = new ArrayList<T>();
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public IFormat<T> getFormat() {
        return this.format;
    }

    public void setFormat(IFormat<T> format) {
        this.format = format;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void setChildren(List<Column> children) {
        this.children = children;
    }

    public IDrawFormat<T> getDrawFormat() {
        return this.drawFormat;
    }

    public void setDrawFormat(IDrawFormat<T> drawFormat) {
        this.drawFormat = drawFormat;
    }

    public boolean isParent() {
        return this.isParent;
    }

    public void setParent(boolean parent) {
        this.isParent = parent;
    }

    public List<T> getDatas() {
        return this.datas;
    }

    public void setDatas(List<T> datas) {
        this.datas = datas;
    }

    public T getData(Object o) throws NoSuchFieldException, IllegalAccessException {
        String[] fieldNames;
        String firstFieldName;
        Class<?> clazz = o.getClass();
        Field field = clazz.getDeclaredField(firstFieldName = (fieldNames = this.fieldName.split("\\.")).length == 0 ? this.fieldName : fieldNames[0]);
        if (field != null) {
            Object child = o;
            if (fieldNames.length == 0 || fieldNames.length == 1) {
                return this.getFieldValue(field, o, true);
            }
            for (int i = 0; i < fieldNames.length; ++i) {
                if (child == null) {
                    return null;
                }
                Class<?> childClazz = child.getClass();
                Field childField = childClazz.getDeclaredField(fieldNames[i]);
                if (childField == null) {
                    return null;
                }
                if (i == fieldNames.length - 1) {
                    return this.getFieldValue(childField, child, true);
                }
                field.setAccessible(true);
                child = field.get(child);
            }
        }
        return null;
    }

    public void fillData(List<Object> objects, TableInfo tableInfo, TableConfig config) throws NoSuchFieldException, IllegalAccessException {
        if (this.countFormat != null) {
            this.countFormat.clearCount();
        }
        if (objects.size() > 0) {
            String[] fieldNames;
            String firstFieldName;
            int[] lineHeightArray = tableInfo.getLineHeightArray();
            Object firstObject = objects.get(0);
            Class<?> clazz = firstObject.getClass();
            Field field = clazz.getDeclaredField(firstFieldName = (fieldNames = this.fieldName.split("\\.")).length == 0 ? this.fieldName : fieldNames[0]);
            if (field != null) {
                int size = objects.size();
                block0: for (int k = 0; k < size; ++k) {
                    Object o;
                    Object child = o = objects.get(k);
                    if (o == null) {
                        this.addData(null, true);
                        this.setRowHeight(config, lineHeightArray, k, null);
                        continue;
                    }
                    if (fieldNames.length == 0 || fieldNames.length == 1) {
                        T t = this.getFieldValue(field, o, true);
                        this.setRowHeight(config, lineHeightArray, k, t);
                        continue;
                    }
                    for (int i = 0; i < fieldNames.length; ++i) {
                        if (child == null) {
                            this.addData(null, true);
                            this.setRowHeight(config, lineHeightArray, k, null);
                            continue block0;
                        }
                        Class<?> childClazz = child.getClass();
                        Field childField = childClazz.getDeclaredField(fieldNames[i]);
                        if (childField == null) {
                            this.addData(null, true);
                            this.setRowHeight(config, lineHeightArray, k, null);
                            continue block0;
                        }
                        if (i == fieldNames.length - 1) {
                            T t = this.getFieldValue(childField, child, true);
                            this.setRowHeight(config, lineHeightArray, k, t);
                            continue;
                        }
                        field.setAccessible(true);
                        child = field.get(child);
                    }
                }
            }
        }
    }

    public List<int[]> parseRanges() {
        if (this.isAutoMerge && this.maxMergeCount > 1 && this.datas != null) {
            if (this.ranges != null) {
                this.ranges.clear();
            } else {
                this.ranges = new ArrayList<int[]>();
            }
            int size = this.datas.size();
            String perVal = null;
            int rangeStartPosition = -1;
            int rangeCount = 1;
            for (int i = 0; i < size; ++i) {
                String val = this.format(this.datas.get(i));
                if (rangeCount < this.maxMergeCount && perVal != null && val != null && val.length() != 0 && val.equals(perVal)) {
                    if (rangeStartPosition == -1) {
                        rangeStartPosition = i - 1;
                    }
                    ++rangeCount;
                } else if (rangeStartPosition != -1) {
                    int[] range = new int[]{rangeStartPosition, i - 1};
                    this.ranges.add(range);
                    rangeStartPosition = -1;
                    rangeCount = 1;
                }
                perVal = val;
            }
        }
        return this.ranges;
    }

    public void parseData(TableInfo tableInfo, TableConfig config) {
        if (this.datas != null) {
            int size = this.datas.size();
            int[] lineHeightArray = tableInfo.getLineHeightArray();
            for (int i = 0; i < size; ++i) {
                this.setRowHeight(config, lineHeightArray, i, null);
            }
        }
    }

    public String format(int position) {
        if (position >= 0 && position < this.datas.size()) {
            return this.format(this.datas.get(position));
        }
        return "";
    }

    public String format(T t) {
        String value = this.format != null ? this.format.format(t) : (t == null ? "" : t.toString());
        return value;
    }

    private void setRowHeight(TableConfig config, int[] lineHeightArray, int position, T t) {
        int height;
        if (t != null && this.isAutoCount && this.countFormat == null) {
            this.countFormat = LetterUtils.isBasicType(t) ? (LetterUtils.isNumber(this) ? new NumberCountFormat() : new DecimalCountFormat()) : new StringCountFormat(this);
        }
        if (this.countFormat != null) {
            this.countFormat.count(t);
        }
        if ((height = this.drawFormat.measureHeight(this, position, config) + 2 * config.getVerticalPadding()) > lineHeightArray[position]) {
            lineHeightArray[position] = height;
        }
    }

    public void addData(List<Object> objects, TableInfo tableInfo, TableConfig config, int startPosition, boolean isFoot) throws NoSuchFieldException, IllegalAccessException {
        if (objects.size() + startPosition == this.datas.size()) {
            return;
        }
        if (objects.size() > 0) {
            String[] fieldNames;
            String firstFieldName;
            int[] lineHeightArray = tableInfo.getLineHeightArray();
            Object firstObject = objects.get(0);
            Class<?> clazz = firstObject.getClass();
            Field field = clazz.getDeclaredField(firstFieldName = (fieldNames = this.fieldName.split("\\.")).length == 0 ? this.fieldName : fieldNames[0]);
            if (field != null) {
                int size = objects.size();
                block0: for (int k = 0; k < size; ++k) {
                    Object o;
                    Object child = o = objects.get(isFoot ? k : size - 1 - k);
                    if (o == null) {
                        this.addData(null, isFoot);
                        this.setRowHeight(config, lineHeightArray, k + startPosition, null);
                        continue;
                    }
                    if (fieldNames.length == 0 || fieldNames.length == 1) {
                        T t = this.getFieldValue(field, o, isFoot);
                        this.setRowHeight(config, lineHeightArray, k + startPosition, t);
                        continue;
                    }
                    for (int i = 0; i < fieldNames.length; ++i) {
                        if (child == null) {
                            this.addData(null, isFoot);
                            this.setRowHeight(config, lineHeightArray, k + startPosition, null);
                            continue block0;
                        }
                        Class<?> childClazz = child.getClass();
                        Field childField = childClazz.getDeclaredField(fieldNames[i]);
                        if (childField == null) {
                            this.addData(null, isFoot);
                            this.setRowHeight(config, lineHeightArray, k + startPosition, null);
                            continue block0;
                        }
                        if (i == fieldNames.length - 1) {
                            T t = this.getFieldValue(childField, child, isFoot);
                            this.setRowHeight(config, lineHeightArray, k + startPosition, t);
                            continue;
                        }
                        field.setAccessible(true);
                        child = field.get(child);
                    }
                }
            }
        }
    }

    private void addData(T t, boolean isFoot) {
        if (isFoot) {
            this.datas.add(t);
        } else {
            this.datas.add(0, t);
        }
    }

    private T getFieldValue(Field field, Object o, boolean isFoot) throws IllegalAccessException {
        field.setAccessible(true);
        Object t = field.get(o);
        this.addData(t, isFoot);
        return (T)t;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public String getTotalNumString() {
        if (this.countFormat != null) {
            return this.countFormat.getCountString();
        }
        return "";
    }

    public List<Column> getChildren() {
        return this.children;
    }

    public void addChildren(Column column) {
        this.children.add(column);
    }

    public Comparator<T> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<T> comparator) {
        this.comparator = comparator;
    }

    public ICountFormat<T, ? extends Number> getCountFormat() {
        return this.countFormat;
    }

    public void setCountFormat(ICountFormat<T, ? extends Number> countFormat) {
        this.countFormat = countFormat;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public int compareTo(Column o) {
        return this.id - o.getId();
    }

    public boolean isAutoCount() {
        return this.isAutoCount;
    }

    public void setAutoCount(boolean autoCount) {
        this.isAutoCount = autoCount;
    }

    public boolean isReverseSort() {
        return this.isReverseSort;
    }

    public void setReverseSort(boolean reverseSort) {
        this.isReverseSort = reverseSort;
    }

    public OnColumnItemClickListener<T> getOnColumnItemClickListener() {
        return this.onColumnItemClickListener;
    }

    public void setOnColumnItemClickListener(OnColumnItemClickListener<T> onColumnItemClickListener) {
        this.onColumnItemClickListener = onColumnItemClickListener;
    }

    public boolean isFixed() {
        return this.isFixed;
    }

    public void setFixed(boolean fixed) {
        this.isFixed = fixed;
    }

    public Paint.Align getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(Paint.Align textAlign) {
        this.textAlign = textAlign;
    }

    public boolean isAutoMerge() {
        return this.isAutoMerge;
    }

    public void setAutoMerge(boolean autoMerge) {
        this.isAutoMerge = autoMerge;
    }

    public int getMaxMergeCount() {
        return this.maxMergeCount;
    }

    public void setMaxMergeCount(int maxMergeCount) {
        this.maxMergeCount = maxMergeCount;
    }
}

