/*
 * Decompiled with CFR 0.152.
 */
package com.bin.david.form.data;

import android.graphics.Rect;
import com.bin.david.form.data.Cell;

public class TableInfo {
    private int topHeight;
    private int titleHeight;
    private int tableTitleSize;
    private int yAxisWidth;
    private int countHeight;
    private int titleDirection;
    private Rect tableRect;
    private int maxLevel = 1;
    private int columnSize;
    private int[] lineHeightArray;
    private float zoom = 1.0f;
    private Cell[][] rangeCells;

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public void setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
    }

    public int getColumnSize() {
        return this.columnSize;
    }

    public void setColumnSize(int columnSize) {
        this.columnSize = columnSize;
        this.rangeCells = new Cell[this.lineHeightArray.length][columnSize];
    }

    public int getTopHeight() {
        return this.topHeight;
    }

    public int getTopHeight(float zoom) {
        return (int)((float)this.topHeight * zoom);
    }

    public void setTopHeight(int topHeight) {
        this.topHeight = topHeight;
    }

    public int getTitleHeight() {
        return (int)((float)this.titleHeight * this.zoom);
    }

    public void setTitleHeight(int titleHeight) {
        this.titleHeight = titleHeight;
    }

    public Rect getTableRect() {
        return this.tableRect;
    }

    public void setTableRect(Rect tableRect) {
        this.tableRect = tableRect;
    }

    public int getyAxisWidth() {
        return this.yAxisWidth;
    }

    public void setLineSize(int lineSize) {
        this.lineHeightArray = new int[lineSize];
    }

    public void addLine(int count) {
        int size = this.lineHeightArray.length;
        int[] tempArray = new int[size + count];
        System.arraycopy(this.lineHeightArray, 0, tempArray, 0, size);
        this.lineHeightArray = tempArray;
        Cell[][] tempPoints = new Cell[size + count][this.columnSize];
        System.arraycopy(this.rangeCells, 0, tempPoints, 0, size);
        this.rangeCells = tempPoints;
    }

    public int getCountHeight() {
        return (int)(this.zoom * (float)this.countHeight);
    }

    public void setCountHeight(int countHeight) {
        this.countHeight = countHeight;
    }

    public int[] getLineHeightArray() {
        return this.lineHeightArray;
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setZoom(float zoom) {
        this.zoom = zoom;
    }

    public void setyAxisWidth(int yAxisWidth) {
        this.yAxisWidth = yAxisWidth;
    }

    public int getTableTitleSize() {
        return this.tableTitleSize;
    }

    public void setTableTitleSize(int tableTitleSize) {
        this.tableTitleSize = tableTitleSize;
    }

    public int getTitleDirection() {
        return this.titleDirection;
    }

    public void setTitleDirection(int titleDirection) {
        this.titleDirection = titleDirection;
    }

    public Cell[][] getRangeCells() {
        return this.rangeCells;
    }

    public void clear() {
        this.rangeCells = null;
        this.lineHeightArray = null;
        this.tableRect = null;
    }
}

