/*
 * Decompiled with CFR 0.152.
 */
package com.bin.david.form.data.format.draw;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import com.bin.david.form.core.TableConfig;
import com.bin.david.form.data.CellInfo;
import com.bin.david.form.data.Column;
import com.bin.david.form.data.format.draw.TextDrawFormat;
import com.bin.david.form.utils.DensityUtils;
import com.bin.david.form.utils.DrawUtils;

public class MultiLineDrawFormat<T>
extends TextDrawFormat<T> {
    private int width;
    private TextPaint textPaint = new TextPaint(1);

    public MultiLineDrawFormat(int width) {
        this.width = width;
    }

    public MultiLineDrawFormat(Context context, int dpWidth) {
        this.width = DensityUtils.dp2px(context, dpWidth);
    }

    @Override
    public int measureWidth(Column<T> column, int position, TableConfig config) {
        return this.width;
    }

    @Override
    public int measureHeight(Column<T> column, int position, TableConfig config) {
        config.getContentStyle().fillPaint((Paint)this.textPaint);
        StaticLayout sl = new StaticLayout((CharSequence)column.format(position), this.textPaint, this.width, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
        return sl.getHeight();
    }

    @Override
    public void draw(Canvas c, Column<T> column, T t, String value, Rect rect, int position, TableConfig config) {
        CellInfo<T> cellInfo = this.getCellInfo();
        cellInfo.set(column, t, value, position);
        this.drawBackground(c, cellInfo, rect, config);
        this.setTextPaint(config, t, (Paint)this.textPaint);
        if (column.getTextAlign() != null) {
            this.textPaint.setTextAlign(column.getTextAlign());
        }
        int hPadding = (int)((float)config.getHorizontalPadding() * config.getZoom());
        int vPadding = (int)((float)config.getVerticalPadding() * config.getZoom());
        int realWidth = rect.width() - 2 * hPadding;
        StaticLayout staticLayout = new StaticLayout((CharSequence)column.format(position), this.textPaint, realWidth, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
        c.save();
        c.translate(DrawUtils.getTextCenterX(rect.left + hPadding, rect.right - hPadding, (Paint)this.textPaint), (float)(rect.top + vPadding));
        staticLayout.draw(c);
        c.restore();
    }
}

