/*
 * Decompiled with CFR 0.152.
 */
package com.bin.david.form.data.format.tip;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import com.bin.david.form.data.format.tip.ITip;
import com.bin.david.form.data.style.FontStyle;
import com.bin.david.form.utils.DensityUtils;

public abstract class BaseBubbleTip<C, S>
implements ITip<C, S> {
    public static final int INVALID = 0;
    private Rect tipRect = new Rect();
    private Paint paint = new Paint(1);
    private int padding;
    private Bitmap triangleBitmap;
    private NinePatch ninePatch;
    private boolean isReversal = false;
    protected int deviation;
    private float alpha;
    private int colorFilter = 0;

    public BaseBubbleTip(Context context, int backgroundDrawableID, int triangleDrawableID, FontStyle fontStyle) {
        fontStyle.fillPaint(this.paint);
        this.triangleBitmap = Bitmap.createBitmap((Bitmap)BitmapFactory.decodeResource((Resources)context.getResources(), (int)triangleDrawableID));
        if (this.ninePatch == null) {
            Bitmap bmp_9 = BitmapFactory.decodeResource((Resources)context.getResources(), (int)backgroundDrawableID);
            this.ninePatch = new NinePatch(bmp_9, bmp_9.getNinePatchChunk(), null);
        }
        this.padding = DensityUtils.dp2px(context, 5.0f);
        this.deviation = DensityUtils.dp2px(context, 5.0f);
    }

    @Override
    public void drawTip(Canvas canvas, float x, float y, Rect rect, C c, int position) {
        if (this.isShowTip(c, position)) {
            Object content = this.format(c, position);
            int triangleWidth = this.triangleBitmap.getWidth();
            int triangleHeight = this.triangleBitmap.getHeight();
            int textWidth = this.getTextWidth(content);
            int textHeight = this.getTextHeight(content);
            int w = textWidth + this.padding * 2;
            int h = textHeight + this.padding * 2;
            this.tipRect.left = (int)x - w / 2;
            this.tipRect.right = (int)x + w / 2;
            this.tipRect.bottom = (int)y - triangleHeight + triangleWidth / 8;
            this.tipRect.top = this.tipRect.bottom - h;
            int tranX = 0;
            if (this.tipRect.left < rect.left) {
                tranX = rect.left - this.tipRect.left - triangleWidth / 2;
            } else if (this.tipRect.right > rect.right) {
                tranX = rect.right - this.tipRect.right + triangleWidth / 2;
            }
            if (this.tipRect.top < rect.top) {
                this.showBottom(canvas, x, y, content, textWidth, textHeight, tranX);
            } else if (this.tipRect.bottom > rect.bottom) {
                this.showTop(canvas, x, y, content, textWidth, textHeight, tranX);
            } else if (this.isReversal) {
                this.showBottom(canvas, x, y, content, textWidth, textHeight, tranX);
            } else {
                this.showTop(canvas, x, y, content, textWidth, textHeight, tranX);
            }
        }
    }

    public abstract int getTextHeight(S var1);

    public abstract int getTextWidth(S var1);

    public abstract void drawText(Canvas var1, Rect var2, S var3, int var4, int var5, Paint var6);

    private void showTop(Canvas canvas, float x, float y, S content, int textWidth, int textHeight, int tranX) {
        canvas.save();
        int triangleWidth = this.triangleBitmap.getWidth();
        int triangleHeight = this.triangleBitmap.getHeight();
        this.startColorFilter();
        canvas.drawBitmap(this.triangleBitmap, x - (float)(triangleWidth / 2), y - (float)triangleHeight, this.paint);
        canvas.translate((float)tranX, 0.0f);
        this.ninePatch.draw(canvas, this.tipRect);
        this.clearColorFilter();
        this.drawText(canvas, this.tipRect, content, textWidth, textHeight, this.paint);
        canvas.restore();
    }

    private void showBottom(Canvas canvas, float x, float y, S content, int textWidth, int textHeight, int tranX) {
        canvas.save();
        int triangleWidth = this.triangleBitmap.getWidth();
        int triangleHeight = this.triangleBitmap.getHeight();
        canvas.rotate(180.0f, x, y);
        this.startColorFilter();
        canvas.drawBitmap(this.triangleBitmap, x - (float)(triangleWidth / 2), y - (float)triangleHeight, this.paint);
        canvas.translate((float)(-tranX), 0.0f);
        this.ninePatch.draw(canvas, this.tipRect);
        this.clearColorFilter();
        this.paint.setColorFilter(null);
        canvas.rotate(180.0f, (float)this.tipRect.centerX(), (float)this.tipRect.centerY());
        this.drawText(canvas, this.tipRect, content, textWidth, textHeight, this.paint);
        canvas.restore();
    }

    private void startColorFilter() {
        if (this.colorFilter != 0) {
            this.paint.setColorFilter((ColorFilter)new PorterDuffColorFilter(this.colorFilter, PorterDuff.Mode.SRC_IN));
            this.ninePatch.setPaint(this.paint);
            this.paint.setAlpha((int)(this.alpha * 255.0f));
        }
    }

    private void clearColorFilter() {
        if (this.colorFilter != 0) {
            this.paint.setColorFilter(null);
            this.paint.setAlpha(255);
        }
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    public boolean isReversal() {
        return this.isReversal;
    }

    public void setReversal(boolean reversal) {
        this.isReversal = reversal;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public int getPadding() {
        return this.padding;
    }

    public int getColorFilter() {
        return this.colorFilter;
    }

    public void setColorFilter(int colorFilter) {
        this.colorFilter = colorFilter;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }
}

