/*
 * Decompiled with CFR 0.152.
 */
package com.bin.david.form.data.format.title;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import com.bin.david.form.core.TableConfig;
import com.bin.david.form.data.Column;
import com.bin.david.form.data.format.bg.ICellBackgroundFormat;
import com.bin.david.form.data.format.title.ITitleDrawFormat;

public abstract class BitmapTitleDrawFormat
implements ITitleDrawFormat {
    private int imageWidth;
    private int imageHeight;
    private Rect imgRect;
    private Rect drawRect;
    private boolean isDrawBackground = true;

    public BitmapTitleDrawFormat(int imageWidth, int imageHeight) {
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.imgRect = new Rect();
        this.drawRect = new Rect();
    }

    @Override
    public int measureWidth(Column column, TableConfig config) {
        return this.imageWidth;
    }

    @Override
    public int measureHeight(TableConfig config) {
        return this.imageHeight;
    }

    protected abstract Bitmap getBitmap(Column var1);

    @Override
    public void draw(Canvas c, Column column, Rect rect, TableConfig config) {
        Paint paint = config.getPaint();
        this.drawBackground(c, column, rect, config);
        Bitmap bitmap = this.getBitmap(column);
        if (bitmap != null) {
            paint.setStyle(Paint.Style.FILL);
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            this.imgRect.set(0, 0, width, height);
            float scaleX = (float)width / (float)this.imageWidth;
            float scaleY = (float)height / (float)this.imageHeight;
            if (scaleX > 1.0f || scaleY > 1.0f) {
                if (scaleX > scaleY) {
                    width = (int)((float)width / scaleX);
                    height = this.imageHeight;
                } else {
                    height = (int)((float)height / scaleY);
                    width = this.imageWidth;
                }
            }
            width = (int)((float)width * config.getZoom());
            height = (int)((float)height * config.getZoom());
            int disX = (rect.right - rect.left - width) / 2;
            int disY = (rect.bottom - rect.top - height) / 2;
            this.drawRect.left = rect.left + disX;
            this.drawRect.top = rect.top + disY;
            this.drawRect.right = rect.right - disX;
            this.drawRect.bottom = rect.bottom - disY;
            c.drawBitmap(bitmap, this.imgRect, this.drawRect, paint);
        }
    }

    public boolean drawBackground(Canvas c, Column column, Rect rect, TableConfig config) {
        ICellBackgroundFormat<Column> backgroundFormat = config.getColumnBackgroundFormat();
        if (this.isDrawBackground && backgroundFormat != null) {
            backgroundFormat.drawBackground(c, rect, column, config.getPaint());
            return true;
        }
        return false;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public void setImageHeight(int imageHeight) {
        this.imageHeight = imageHeight;
    }

    public boolean isDrawBackground() {
        return this.isDrawBackground;
    }

    public void setDrawBackground(boolean drawBackground) {
        this.isDrawBackground = drawBackground;
    }
}

