/*
 * Decompiled with CFR 0.152.
 */
package com.bin.david.form.data.format.title;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.LruCache;
import com.bin.david.form.data.Column;
import com.bin.david.form.data.format.title.BitmapTitleDrawFormat;

public abstract class ImageResTitleDrawFormat
extends BitmapTitleDrawFormat {
    private BitmapFactory.Options options = new BitmapFactory.Options();
    private LruCache<Integer, Bitmap> cache;

    public ImageResTitleDrawFormat(int imageWidth, int imageHeight) {
        this(imageWidth, imageHeight, null);
        int maxMemory = (int)(Runtime.getRuntime().maxMemory() / 1024L);
        int cacheSize = maxMemory / 16;
        this.cache = new LruCache<Integer, Bitmap>(cacheSize){

            protected int sizeOf(Integer key, Bitmap bitmap) {
                return bitmap.getRowBytes() * bitmap.getHeight() / 1024;
            }
        };
    }

    public ImageResTitleDrawFormat(int imageWidth, int imageHeight, BitmapFactory.Options options) {
        super(imageWidth, imageHeight);
        this.options = options;
    }

    @Override
    protected Bitmap getBitmap(Column column) {
        int resID = this.getResourceID(column);
        Bitmap bitmap = (Bitmap)this.cache.get((Object)resID);
        if (bitmap == null && (bitmap = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)resID, (BitmapFactory.Options)this.options)) != null) {
            this.cache.put((Object)resID, (Object)bitmap);
        }
        return bitmap;
    }

    protected abstract Context getContext();

    protected abstract int getResourceID(Column var1);
}

