/*
 * Decompiled with CFR 0.152.
 */
package com.bin.david.form.data.format.title;

import android.graphics.Canvas;
import android.graphics.Rect;
import com.bin.david.form.core.TableConfig;
import com.bin.david.form.data.Column;
import com.bin.david.form.data.format.title.ImageResTitleDrawFormat;
import com.bin.david.form.data.format.title.TitleDrawFormat;
import com.bin.david.form.exception.TableException;

public abstract class TitleImageDrawFormat
extends ImageResTitleDrawFormat {
    public static final int LEFT = 0;
    public static final int TOP = 1;
    public static final int RIGHT = 2;
    public static final int BOTTOM = 3;
    private TitleDrawFormat textDrawFormat = new TitleDrawFormat();
    private int drawPadding;
    private int direction;
    private int verticalPadding;
    private int horizontalPadding;
    private Rect rect;

    public TitleImageDrawFormat(int imageWidth, int imageHeight, int drawPadding) {
        this(imageWidth, imageHeight, 0, drawPadding);
    }

    public TitleImageDrawFormat(int imageWidth, int imageHeight, int direction, int drawPadding) {
        super(imageWidth, imageHeight);
        this.direction = direction;
        this.drawPadding = drawPadding;
        if (direction > 3 || direction < 0) {
            throw new TableException("Please set the direction less than 3 greater than 0");
        }
        this.rect = new Rect();
    }

    @Override
    public int measureWidth(Column column, TableConfig config) {
        int textWidth = this.textDrawFormat.measureWidth(column, config);
        this.horizontalPadding = config.getColumnTitleHorizontalPadding();
        if (this.direction == 0 || this.direction == 2) {
            return this.getImageWidth() + textWidth + this.drawPadding;
        }
        return Math.max(super.measureWidth(column, config), textWidth);
    }

    @Override
    public int measureHeight(TableConfig config) {
        int imgHeight = super.measureHeight(config);
        int textHeight = this.textDrawFormat.measureHeight(config);
        this.verticalPadding = config.getColumnTitleVerticalPadding();
        if (this.direction == 1 || this.direction == 3) {
            return this.getImageHeight() + textHeight + this.drawPadding;
        }
        return Math.max(imgHeight, textHeight);
    }

    @Override
    public void draw(Canvas c, Column column, Rect rect, TableConfig config) {
        this.setDrawBackground(true);
        this.drawBackground(c, column, rect, config);
        this.setDrawBackground(false);
        this.textDrawFormat.setDrawBg(false);
        if (this.getBitmap(column) == null) {
            this.textDrawFormat.draw(c, column, rect, config);
            return;
        }
        switch (this.direction) {
            case 0: {
                int width = (int)((float)this.measureWidth(column, config) * config.getZoom());
                int imgLeft = rect.left + (rect.right - rect.left - width) / 2;
                int imgRight = (int)((float)imgLeft + (float)this.getImageWidth() * config.getZoom());
                this.rect.set(imgLeft, rect.top, imgRight, rect.bottom);
                super.draw(c, column, this.rect, config);
                int textWidth = (int)((float)this.textDrawFormat.measureWidth(column, config) * config.getZoom());
                this.rect.set(imgRight + this.drawPadding, rect.top, imgRight + this.drawPadding + textWidth, rect.bottom);
                this.textDrawFormat.draw(c, column, this.rect, config);
                break;
            }
            case 2: {
                int width = (int)((float)this.measureWidth(column, config) * config.getZoom());
                int imgRight = rect.right - (rect.right - rect.left - width) / 2;
                int imgLeft = (int)((float)imgRight - (float)this.getImageWidth() * config.getZoom());
                this.rect.set(imgLeft, rect.top, imgRight, rect.bottom);
                super.draw(c, column, this.rect, config);
                int textWidth = (int)((float)this.textDrawFormat.measureWidth(column, config) * config.getZoom());
                this.rect.set(imgLeft - this.drawPadding - textWidth, rect.top, imgLeft - this.drawPadding, rect.bottom);
                this.textDrawFormat.draw(c, column, this.rect, config);
                break;
            }
            case 1: {
                int height = (int)((float)this.measureHeight(config) * config.getZoom());
                int imgTop = rect.top + (rect.top - rect.bottom - height) / 2;
                int imgBottom = (int)((float)imgTop + (float)this.getImageHeight() * config.getZoom());
                this.rect.set(rect.left, imgTop, rect.right, imgBottom);
                this.textDrawFormat.draw(c, column, this.rect, config);
                int textHeight = (int)((float)this.textDrawFormat.measureHeight(config) * config.getZoom());
                this.rect.set(rect.left, imgBottom + this.drawPadding, rect.right, imgBottom + this.drawPadding + textHeight);
                super.draw(c, column, this.rect, config);
                break;
            }
            case 3: {
                int height = (int)((float)this.measureHeight(config) * config.getZoom());
                int imgBottom = rect.bottom - (rect.bottom - rect.top - height) / 2;
                int imgTop = (int)((float)imgBottom - (float)this.getImageHeight() * config.getZoom());
                this.rect.set(rect.left, imgTop, rect.right, imgBottom);
                this.textDrawFormat.draw(c, column, this.rect, config);
                int textHeight = (int)((float)this.textDrawFormat.measureHeight(config) * config.getZoom());
                this.rect.set(rect.left, imgTop - this.drawPadding - textHeight, rect.right, imgTop - this.drawPadding);
                super.draw(c, column, this.rect, config);
            }
        }
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }
}

