/*
 * Decompiled with CFR 0.152.
 */
package com.bin.david.form.data.table;

import com.bin.david.form.data.Column;
import com.bin.david.form.data.format.title.ITitleDrawFormat;
import com.bin.david.form.data.table.TableData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PageTableData<T>
extends TableData<T> {
    private List<T> totalData;
    private int currentPage;
    private int totalPage;
    private int pageSize;
    List<T> pageData = new ArrayList<T>();

    public PageTableData(String tableName, List<T> t, List<Column> columns) {
        this(tableName, t, columns, null);
    }

    public PageTableData(String tableName, List<T> t, Column ... columns) {
        this(tableName, t, Arrays.asList(columns));
    }

    public PageTableData(String tableName, List<T> t, List<Column> columns, ITitleDrawFormat titleDrawFormat) {
        super(tableName, t, columns, titleDrawFormat);
        this.totalData = t;
        this.pageSize = t.size();
        this.currentPage = 0;
        this.totalPage = 1;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        if (currentPage < 0) {
            currentPage = 0;
        } else if (currentPage >= this.totalPage) {
            currentPage = this.totalPage - 1;
        }
        this.currentPage = currentPage;
        this.pageData.clear();
        int totalSize = this.totalData.size();
        for (int i = currentPage * this.pageSize; i < (currentPage + 1) * this.pageSize; ++i) {
            if (i >= totalSize) continue;
            this.pageData.add(this.totalData.get(i));
        }
        this.setT(this.pageData);
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        int total = this.totalData.size();
        if (pageSize < 1) {
            pageSize = 1;
        } else if (pageSize > total) {
            pageSize = total;
        }
        this.pageSize = pageSize;
        this.totalPage = total / pageSize;
        this.totalPage = total % pageSize == 0 ? this.totalPage : this.totalPage + 1;
        this.setCurrentPage(this.currentPage);
    }
}

