/*
 * Decompiled with CFR 0.152.
 */
package lecho.lib.hellocharts.animation;

import android.os.Handler;
import android.os.SystemClock;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import lecho.lib.hellocharts.animation.ChartAnimationListener;
import lecho.lib.hellocharts.animation.ChartDataAnimator;
import lecho.lib.hellocharts.animation.DummyChartAnimationListener;
import lecho.lib.hellocharts.view.Chart;

public class ChartDataAnimatorV8
implements ChartDataAnimator {
    final Chart chart;
    final Handler handler;
    final Interpolator interpolator = new AccelerateDecelerateInterpolator();
    long start;
    boolean isAnimationStarted = false;
    long duration;
    private final Runnable runnable = new Runnable(){

        @Override
        public void run() {
            long elapsed = SystemClock.uptimeMillis() - ChartDataAnimatorV8.this.start;
            if (elapsed > ChartDataAnimatorV8.this.duration) {
                ChartDataAnimatorV8.this.isAnimationStarted = false;
                ChartDataAnimatorV8.this.handler.removeCallbacks(ChartDataAnimatorV8.this.runnable);
                ChartDataAnimatorV8.this.chart.animationDataFinished();
                return;
            }
            float scale = Math.min(ChartDataAnimatorV8.this.interpolator.getInterpolation((float)elapsed / (float)ChartDataAnimatorV8.this.duration), 1.0f);
            ChartDataAnimatorV8.this.chart.animationDataUpdate(scale);
            ChartDataAnimatorV8.this.handler.postDelayed((Runnable)this, 16L);
        }
    };
    private ChartAnimationListener animationListener = new DummyChartAnimationListener();

    public ChartDataAnimatorV8(Chart chart) {
        this.chart = chart;
        this.handler = new Handler();
    }

    @Override
    public void startAnimation(long duration) {
        this.duration = duration >= 0L ? duration : 500L;
        this.isAnimationStarted = true;
        this.animationListener.onAnimationStarted();
        this.start = SystemClock.uptimeMillis();
        this.handler.post(this.runnable);
    }

    @Override
    public void cancelAnimation() {
        this.isAnimationStarted = false;
        this.handler.removeCallbacks(this.runnable);
        this.chart.animationDataFinished();
        this.animationListener.onAnimationFinished();
    }

    @Override
    public boolean isAnimationStarted() {
        return this.isAnimationStarted;
    }

    @Override
    public void setChartAnimationListener(ChartAnimationListener animationListener) {
        this.animationListener = null == animationListener ? new DummyChartAnimationListener() : animationListener;
    }
}

