/*
 * Decompiled with CFR 0.152.
 */
package lecho.lib.hellocharts.view;

import android.content.Context;
import android.graphics.RectF;
import android.os.Build;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.View;
import lecho.lib.hellocharts.animation.PieChartRotationAnimator;
import lecho.lib.hellocharts.animation.PieChartRotationAnimatorV14;
import lecho.lib.hellocharts.animation.PieChartRotationAnimatorV8;
import lecho.lib.hellocharts.gesture.PieChartTouchHandler;
import lecho.lib.hellocharts.listener.DummyPieChartOnValueSelectListener;
import lecho.lib.hellocharts.listener.PieChartOnValueSelectListener;
import lecho.lib.hellocharts.model.ChartData;
import lecho.lib.hellocharts.model.PieChartData;
import lecho.lib.hellocharts.model.SelectedValue;
import lecho.lib.hellocharts.model.SliceValue;
import lecho.lib.hellocharts.provider.PieChartDataProvider;
import lecho.lib.hellocharts.renderer.PieChartRenderer;
import lecho.lib.hellocharts.view.AbstractChartView;

public class PieChartView
extends AbstractChartView
implements PieChartDataProvider {
    private static final String TAG = "PieChartView";
    protected PieChartData data;
    protected PieChartOnValueSelectListener onValueTouchListener = new DummyPieChartOnValueSelectListener();
    protected PieChartRenderer pieChartRenderer;
    protected PieChartRotationAnimator rotationAnimator;

    public PieChartView(Context context) {
        this(context, null, 0);
    }

    public PieChartView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PieChartView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.pieChartRenderer = new PieChartRenderer(context, this, this);
        this.touchHandler = new PieChartTouchHandler(context, this);
        this.setChartRenderer(this.pieChartRenderer);
        this.rotationAnimator = Build.VERSION.SDK_INT < 14 ? new PieChartRotationAnimatorV8(this) : new PieChartRotationAnimatorV14(this);
        this.setPieChartData(PieChartData.generateDummyData());
    }

    @Override
    public PieChartData getPieChartData() {
        return this.data;
    }

    @Override
    public void setPieChartData(PieChartData data) {
        this.data = null == data ? PieChartData.generateDummyData() : data;
        super.onChartDataChange();
    }

    @Override
    public ChartData getChartData() {
        return this.data;
    }

    @Override
    public void callTouchListener() {
        SelectedValue selectedValue = this.chartRenderer.getSelectedValue();
        if (selectedValue.isSet()) {
            SliceValue sliceValue = this.data.getValues().get(selectedValue.getFirstIndex());
            this.onValueTouchListener.onValueSelected(selectedValue.getFirstIndex(), sliceValue);
        } else {
            this.onValueTouchListener.onValueDeselected();
        }
    }

    public PieChartOnValueSelectListener getOnValueTouchListener() {
        return this.onValueTouchListener;
    }

    public void setOnValueTouchListener(PieChartOnValueSelectListener touchListener) {
        if (null != touchListener) {
            this.onValueTouchListener = touchListener;
        }
    }

    public RectF getCircleOval() {
        return this.pieChartRenderer.getCircleOval();
    }

    public void setCircleOval(RectF orginCircleOval) {
        this.pieChartRenderer.setCircleOval(orginCircleOval);
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    public int getChartRotation() {
        return this.pieChartRenderer.getChartRotation();
    }

    public void setChartRotation(int rotation, boolean isAnimated) {
        if (isAnimated) {
            this.rotationAnimator.cancelAnimation();
            this.rotationAnimator.startAnimation(this.pieChartRenderer.getChartRotation(), rotation);
        } else {
            this.pieChartRenderer.setChartRotation(rotation);
        }
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    public boolean isChartRotationEnabled() {
        if (this.touchHandler instanceof PieChartTouchHandler) {
            return ((PieChartTouchHandler)this.touchHandler).isRotationEnabled();
        }
        return false;
    }

    public void setChartRotationEnabled(boolean isRotationEnabled) {
        if (this.touchHandler instanceof PieChartTouchHandler) {
            ((PieChartTouchHandler)this.touchHandler).setRotationEnabled(isRotationEnabled);
        }
    }

    public SliceValue getValueForAngle(int angle, SelectedValue selectedValue) {
        return this.pieChartRenderer.getValueForAngle(angle, selectedValue);
    }

    public float getCircleFillRatio() {
        return this.pieChartRenderer.getCircleFillRatio();
    }

    public void setCircleFillRatio(float fillRatio) {
        this.pieChartRenderer.setCircleFillRatio(fillRatio);
        ViewCompat.postInvalidateOnAnimation((View)this);
    }
}

