/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.provider.Settings;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;

public final class XPermission {
    private static XPermission sInstance;
    private Context context;
    private SimpleCallback mSimpleCallback;

    @RequiresApi(api=23)
    public boolean isGrantedDrawOverlays() {
        return Settings.canDrawOverlays((Context)this.context);
    }

    @RequiresApi(api=23)
    public void requestDrawOverlays(SimpleCallback callback) {
        if (this.isGrantedDrawOverlays()) {
            if (callback != null) {
                callback.onGranted();
            }
            return;
        }
        this.mSimpleCallback = callback;
        PermissionActivity.start(this.context, 3);
    }

    @TargetApi(value=23)
    private void startOverlayPermissionActivity(Activity activity, int requestCode) {
        Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION");
        intent.setData(Uri.parse((String)("package:" + this.context.getPackageName())));
        if (!this.isIntentAvailable(intent)) {
            this.launchAppDetailsSettings();
            return;
        }
        activity.startActivityForResult(intent, requestCode);
    }

    public void launchAppDetailsSettings() {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.parse((String)("package:" + this.context.getPackageName())));
        if (!this.isIntentAvailable(intent)) {
            return;
        }
        this.context.startActivity(intent.addFlags(0x10000000));
    }

    public static XPermission create(Context context) {
        if (sInstance == null) {
            return new XPermission(context);
        }
        XPermission.sInstance.context = context;
        return sInstance;
    }

    private boolean isIntentAvailable(Intent intent) {
        return this.context.getPackageManager().queryIntentActivities(intent, 65536).size() > 0;
    }

    private XPermission(Context ctx) {
        sInstance = this;
        this.context = ctx;
    }

    private void onRequestPermissionsResult(Activity activity) {
    }

    public static interface SimpleCallback {
        public void onGranted();

        public void onDenied();
    }

    @RequiresApi(api=23)
    public static class PermissionActivity
    extends Activity {
        private static final String TYPE = "TYPE";
        public static final int TYPE_DRAW_OVERLAYS = 3;

        public static void start(Context context, int type) {
            Intent starter = new Intent(context, PermissionActivity.class);
            starter.addFlags(0x10000000);
            starter.putExtra(TYPE, type);
            context.startActivity(starter);
        }

        protected void onCreate(@Nullable Bundle savedInstanceState) {
            this.getWindow().addFlags(262672);
            this.getWindow().getAttributes().alpha = 0.0f;
            int byteExtra = this.getIntent().getIntExtra(TYPE, 3);
            if (byteExtra == 3) {
                super.onCreate(savedInstanceState);
                sInstance.startOverlayPermissionActivity(this, 3);
            }
        }

        public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
            sInstance.onRequestPermissionsResult(this);
            this.finish();
        }

        public boolean dispatchTouchEvent(MotionEvent ev) {
            this.finish();
            return true;
        }

        protected void onActivityResult(int requestCode, int resultCode, Intent data) {
            if (requestCode == 3) {
                if (sInstance.mSimpleCallback == null) {
                    return;
                }
                if (sInstance.isGrantedDrawOverlays()) {
                    sInstance.mSimpleCallback.onGranted();
                } else {
                    sInstance.mSimpleCallback.onDenied();
                }
            }
            this.finish();
        }
    }
}

