/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;

public class EncryptDecryptResponse
extends TpmStructure {
    public byte[] outData;
    public byte[] ivOut;

    public EncryptDecryptResponse(byte[] _outData, byte[] _ivOut) {
        this.outData = _outData;
        this.ivOut = _ivOut;
    }

    public EncryptDecryptResponse() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.outData != null ? this.outData.length : 0, 2);
        if (this.outData != null) {
            buf.write(this.outData);
        }
        buf.writeInt(this.ivOut != null ? this.ivOut.length : 0, 2);
        if (this.ivOut != null) {
            buf.write(this.ivOut);
        }
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _outDataSize = buf.readInt(2);
        this.outData = new byte[_outDataSize];
        buf.readArrayOfInts(this.outData, 1, _outDataSize);
        int _ivOutSize = buf.readInt(2);
        this.ivOut = new byte[_ivOutSize];
        buf.readArrayOfInts(this.ivOut, 1, _ivOutSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static EncryptDecryptResponse fromTpm(byte[] x) {
        EncryptDecryptResponse ret = new EncryptDecryptResponse();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static EncryptDecryptResponse fromTpm(InByteBuf buf) {
        EncryptDecryptResponse ret = new EncryptDecryptResponse();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_EncryptDecrypt_RESPONSE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "byte", "outData", this.outData);
        _p.add(d, "byte", "ivOut", this.ivOut);
    }
}

