/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_RC;

public class GetTestResultResponse
extends TpmStructure {
    public byte[] outData;
    public TPM_RC testResult;

    public GetTestResultResponse(byte[] _outData, TPM_RC _testResult) {
        this.outData = _outData;
        this.testResult = _testResult;
    }

    public GetTestResultResponse() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.outData != null ? this.outData.length : 0, 2);
        if (this.outData != null) {
            buf.write(this.outData);
        }
        this.testResult.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _outDataSize = buf.readInt(2);
        this.outData = new byte[_outDataSize];
        buf.readArrayOfInts(this.outData, 1, _outDataSize);
        this.testResult = TPM_RC.fromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static GetTestResultResponse fromTpm(byte[] x) {
        GetTestResultResponse ret = new GetTestResultResponse();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static GetTestResultResponse fromTpm(InByteBuf buf) {
        GetTestResultResponse ret = new GetTestResultResponse();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_GetTestResult_RESPONSE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "byte", "outData", this.outData);
        _p.add(d, "TPM_RC", "testResult", this.testResult);
    }
}

