/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import java.util.Collection;
import tss.InByteBuf;
import tss.TpmEnum;
import tss.tpm.Implementation;
import tss.tpm.TPM_CC;

public final class ImplementationConstants
extends TpmEnum<ImplementationConstants> {
    private static TpmEnum.ValueMap<ImplementationConstants> _ValueMap = new TpmEnum.ValueMap();
    public static final ImplementationConstants OSSL = new ImplementationConstants(1, _N.OSSL);
    public static final ImplementationConstants LTC = new ImplementationConstants(2, _N.LTC);
    public static final ImplementationConstants MSBN = new ImplementationConstants(3, _N.MSBN);
    public static final ImplementationConstants SYMCRYPT = new ImplementationConstants(4, _N.SYMCRYPT);
    public static final ImplementationConstants HASH_COUNT = new ImplementationConstants(3, _N.HASH_COUNT);
    public static final ImplementationConstants MAX_SYM_KEY_BITS = new ImplementationConstants(256, _N.MAX_SYM_KEY_BITS);
    public static final ImplementationConstants MAX_SYM_KEY_BYTES = new ImplementationConstants((MAX_SYM_KEY_BITS.toInt() + 7) / 8, _N.MAX_SYM_KEY_BYTES);
    public static final ImplementationConstants MAX_SYM_BLOCK_SIZE = new ImplementationConstants(16, _N.MAX_SYM_BLOCK_SIZE);
    public static final ImplementationConstants MAX_CAP_CC = new ImplementationConstants(TPM_CC.LAST.toInt(), _N.MAX_CAP_CC);
    public static final ImplementationConstants MAX_RSA_KEY_BYTES = new ImplementationConstants(256, _N.MAX_RSA_KEY_BYTES);
    public static final ImplementationConstants MAX_AES_KEY_BYTES = new ImplementationConstants(32, _N.MAX_AES_KEY_BYTES);
    public static final ImplementationConstants MAX_ECC_KEY_BYTES = new ImplementationConstants(48, _N.MAX_ECC_KEY_BYTES);
    public static final ImplementationConstants LABEL_MAX_BUFFER = new ImplementationConstants(32, _N.LABEL_MAX_BUFFER);
    public static final ImplementationConstants MAX_CAP_DATA = new ImplementationConstants(Implementation.MAX_CAP_BUFFER.toInt() - 1 - 1, _N.MAX_CAP_DATA);
    public static final ImplementationConstants MAX_CAP_ALGS = new ImplementationConstants(MAX_CAP_DATA.toInt() / 1, _N.MAX_CAP_ALGS);
    public static final ImplementationConstants MAX_CAP_HANDLES = new ImplementationConstants(MAX_CAP_DATA.toInt() / 1, _N.MAX_CAP_HANDLES);
    public static final ImplementationConstants MAX_TPM_PROPERTIES = new ImplementationConstants(MAX_CAP_DATA.toInt() / 1, _N.MAX_TPM_PROPERTIES);
    public static final ImplementationConstants MAX_PCR_PROPERTIES = new ImplementationConstants(MAX_CAP_DATA.toInt() / 1, _N.MAX_PCR_PROPERTIES);
    public static final ImplementationConstants MAX_ECC_CURVES = new ImplementationConstants(MAX_CAP_DATA.toInt() / 1, _N.MAX_ECC_CURVES);
    public static final ImplementationConstants MAX_TAGGED_POLICIES = new ImplementationConstants(MAX_CAP_DATA.toInt() / 1, _N.MAX_TAGGED_POLICIES);
    public static final ImplementationConstants MAX_AC_CAPABILITIES = new ImplementationConstants(MAX_CAP_DATA.toInt() / 1, _N.MAX_AC_CAPABILITIES);

    public ImplementationConstants(int value) {
        super(value, _ValueMap);
    }

    public static ImplementationConstants fromInt(int value) {
        return TpmEnum.fromInt(value, _ValueMap, ImplementationConstants.class);
    }

    public static ImplementationConstants fromTpm(byte[] buf) {
        return TpmEnum.fromTpm(buf, _ValueMap, ImplementationConstants.class);
    }

    public static ImplementationConstants fromTpm(InByteBuf buf) {
        return TpmEnum.fromTpm(buf, _ValueMap, ImplementationConstants.class);
    }

    public _N asEnum() {
        return (_N)this.NameAsEnum;
    }

    public static Collection<ImplementationConstants> values() {
        return _ValueMap.values();
    }

    private ImplementationConstants(int value, _N nameAsEnum) {
        super(value, nameAsEnum, _ValueMap);
    }

    private ImplementationConstants(int value, _N nameAsEnum, boolean noConvFromInt) {
        super(value, nameAsEnum, null);
    }

    @Override
    protected int wireSize() {
        return 4;
    }

    public static enum _N {
        OSSL,
        LTC,
        MSBN,
        SYMCRYPT,
        HASH_COUNT,
        MAX_SYM_KEY_BITS,
        MAX_SYM_KEY_BYTES,
        MAX_SYM_BLOCK_SIZE,
        MAX_CAP_CC,
        MAX_RSA_KEY_BYTES,
        MAX_AES_KEY_BYTES,
        MAX_ECC_KEY_BYTES,
        LABEL_MAX_BUFFER,
        MAX_CAP_DATA,
        MAX_CAP_ALGS,
        MAX_CAP_HANDLES,
        MAX_TPM_PROPERTIES,
        MAX_PCR_PROPERTIES,
        MAX_ECC_CURVES,
        MAX_TAGGED_POLICIES,
        MAX_AC_CAPABILITIES;

    }
}

