/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMA_SESSION;
import tss.tpm.TPM_HANDLE;

public class SessionIn
extends TpmStructure {
    public TPM_HANDLE handle;
    public byte[] nonceCaller;
    public TPMA_SESSION attributes;
    public byte[] auth;

    public SessionIn(TPM_HANDLE _handle, byte[] _nonceCaller, TPMA_SESSION _attributes, byte[] _auth) {
        this.handle = _handle;
        this.nonceCaller = _nonceCaller;
        this.attributes = _attributes;
        this.auth = _auth;
    }

    public SessionIn() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.handle.toTpm(buf);
        buf.writeInt(this.nonceCaller != null ? this.nonceCaller.length : 0, 2);
        if (this.nonceCaller != null) {
            buf.write(this.nonceCaller);
        }
        this.attributes.toTpm(buf);
        buf.writeInt(this.auth != null ? this.auth.length : 0, 2);
        if (this.auth != null) {
            buf.write(this.auth);
        }
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.handle = TPM_HANDLE.fromTpm(buf);
        int _nonceCallerSize = buf.readInt(2);
        this.nonceCaller = new byte[_nonceCallerSize];
        buf.readArrayOfInts(this.nonceCaller, 1, _nonceCallerSize);
        int _attributes = buf.readInt(1);
        this.attributes = TPMA_SESSION.fromInt(_attributes);
        int _authSize = buf.readInt(2);
        this.auth = new byte[_authSize];
        buf.readArrayOfInts(this.auth, 1, _authSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static SessionIn fromTpm(byte[] x) {
        SessionIn ret = new SessionIn();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static SessionIn fromTpm(InByteBuf buf) {
        SessionIn ret = new SessionIn();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("SessionIn");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "handle", this.handle);
        _p.add(d, "byte", "nonceCaller", this.nonceCaller);
        _p.add(d, "TPMA_SESSION", "attributes", this.attributes);
        _p.add(d, "byte", "auth", this.auth);
    }
}

