/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import java.util.Stack;
import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_PCR_SELECTION;
import tss.tpm.TPMS_SENSITIVE_CREATE;
import tss.tpm.TPMT_PUBLIC;
import tss.tpm.TPM_HANDLE;

public class TPM2_CreatePrimary_REQUEST
extends TpmStructure {
    public TPM_HANDLE primaryHandle;
    public TPMS_SENSITIVE_CREATE inSensitive;
    public TPMT_PUBLIC inPublic;
    public byte[] outsideInfo;
    public TPMS_PCR_SELECTION[] creationPCR;

    public TPM2_CreatePrimary_REQUEST(TPM_HANDLE _primaryHandle, TPMS_SENSITIVE_CREATE _inSensitive, TPMT_PUBLIC _inPublic, byte[] _outsideInfo, TPMS_PCR_SELECTION[] _creationPCR) {
        this.primaryHandle = _primaryHandle;
        this.inSensitive = _inSensitive;
        this.inPublic = _inPublic;
        this.outsideInfo = _outsideInfo;
        this.creationPCR = _creationPCR;
    }

    public TPM2_CreatePrimary_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.primaryHandle.toTpm(buf);
        buf.writeInt(this.inSensitive != null ? this.inSensitive.toTpm().length : 0, 2);
        if (this.inSensitive != null) {
            this.inSensitive.toTpm(buf);
        }
        buf.writeInt(this.inPublic != null ? this.inPublic.toTpm().length : 0, 2);
        if (this.inPublic != null) {
            this.inPublic.toTpm(buf);
        }
        buf.writeInt(this.outsideInfo != null ? this.outsideInfo.length : 0, 2);
        if (this.outsideInfo != null) {
            buf.write(this.outsideInfo);
        }
        buf.writeInt(this.creationPCR != null ? this.creationPCR.length : 0, 4);
        if (this.creationPCR != null) {
            buf.writeArrayOfTpmObjects(this.creationPCR);
        }
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.primaryHandle = TPM_HANDLE.fromTpm(buf);
        int _inSensitiveSize = buf.readInt(2);
        Stack<InByteBuf.SizedStructInfo> stack = buf.structSize;
        InByteBuf inByteBuf = buf;
        inByteBuf.getClass();
        stack.push(inByteBuf.new InByteBuf.SizedStructInfo(buf.curPos(), _inSensitiveSize));
        this.inSensitive = TPMS_SENSITIVE_CREATE.fromTpm(buf);
        buf.structSize.pop();
        int _inPublicSize = buf.readInt(2);
        Stack<InByteBuf.SizedStructInfo> stack2 = buf.structSize;
        InByteBuf inByteBuf2 = buf;
        inByteBuf2.getClass();
        stack2.push(inByteBuf2.new InByteBuf.SizedStructInfo(buf.curPos(), _inPublicSize));
        this.inPublic = TPMT_PUBLIC.fromTpm(buf);
        buf.structSize.pop();
        int _outsideInfoSize = buf.readInt(2);
        this.outsideInfo = new byte[_outsideInfoSize];
        buf.readArrayOfInts(this.outsideInfo, 1, _outsideInfoSize);
        int _creationPCRCount = buf.readInt(4);
        this.creationPCR = new TPMS_PCR_SELECTION[_creationPCRCount];
        for (int j = 0; j < _creationPCRCount; ++j) {
            this.creationPCR[j] = new TPMS_PCR_SELECTION();
        }
        buf.readArrayOfTpmObjects(this.creationPCR, _creationPCRCount);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_CreatePrimary_REQUEST fromTpm(byte[] x) {
        TPM2_CreatePrimary_REQUEST ret = new TPM2_CreatePrimary_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_CreatePrimary_REQUEST fromTpm(InByteBuf buf) {
        TPM2_CreatePrimary_REQUEST ret = new TPM2_CreatePrimary_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_CreatePrimary_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "primaryHandle", this.primaryHandle);
        _p.add(d, "TPMS_SENSITIVE_CREATE", "inSensitive", this.inSensitive);
        _p.add(d, "TPMT_PUBLIC", "inPublic", this.inPublic);
        _p.add(d, "byte", "outsideInfo", this.outsideInfo);
        _p.add(d, "TPMS_PCR_SELECTION", "creationPCR", this.creationPCR);
    }
}

