/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_HANDLE;

public class TPM2_Hash_REQUEST
extends TpmStructure {
    public byte[] data;
    public TPM_ALG_ID hashAlg;
    public TPM_HANDLE hierarchy;

    public TPM2_Hash_REQUEST(byte[] _data, TPM_ALG_ID _hashAlg, TPM_HANDLE _hierarchy) {
        this.data = _data;
        this.hashAlg = _hashAlg;
        this.hierarchy = _hierarchy;
    }

    public TPM2_Hash_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.data != null ? this.data.length : 0, 2);
        if (this.data != null) {
            buf.write(this.data);
        }
        this.hashAlg.toTpm(buf);
        this.hierarchy.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _dataSize = buf.readInt(2);
        this.data = new byte[_dataSize];
        buf.readArrayOfInts(this.data, 1, _dataSize);
        this.hashAlg = TPM_ALG_ID.fromTpm(buf);
        this.hierarchy = TPM_HANDLE.fromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_Hash_REQUEST fromTpm(byte[] x) {
        TPM2_Hash_REQUEST ret = new TPM2_Hash_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_Hash_REQUEST fromTpm(InByteBuf buf) {
        TPM2_Hash_REQUEST ret = new TPM2_Hash_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_Hash_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "byte", "data", this.data);
        _p.add(d, "TPM_ALG_ID", "hashAlg", this.hashAlg);
        _p.add(d, "TPM_HANDLE", "hierarchy", this.hierarchy);
    }
}

