/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_HANDLE;

public class TPM2_NV_Read_REQUEST
extends TpmStructure {
    public TPM_HANDLE authHandle;
    public TPM_HANDLE nvIndex;
    public short size;
    public short offset;

    public TPM2_NV_Read_REQUEST(TPM_HANDLE _authHandle, TPM_HANDLE _nvIndex, int _size, int _offset) {
        this.authHandle = _authHandle;
        this.nvIndex = _nvIndex;
        this.size = (short)_size;
        this.offset = (short)_offset;
    }

    public TPM2_NV_Read_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.authHandle.toTpm(buf);
        this.nvIndex.toTpm(buf);
        buf.write(this.size);
        buf.write(this.offset);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.authHandle = TPM_HANDLE.fromTpm(buf);
        this.nvIndex = TPM_HANDLE.fromTpm(buf);
        this.size = (short)buf.readInt(2);
        this.offset = (short)buf.readInt(2);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_NV_Read_REQUEST fromTpm(byte[] x) {
        TPM2_NV_Read_REQUEST ret = new TPM2_NV_Read_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_NV_Read_REQUEST fromTpm(InByteBuf buf) {
        TPM2_NV_Read_REQUEST ret = new TPM2_NV_Read_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_NV_Read_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "authHandle", this.authHandle);
        _p.add(d, "TPM_HANDLE", "nvIndex", this.nvIndex);
        _p.add(d, "ushort", "size", this.size);
        _p.add(d, "ushort", "offset", this.offset);
    }
}

