/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_HANDLE;

public class TPM2_PCR_SetAuthValue_REQUEST
extends TpmStructure {
    public TPM_HANDLE pcrHandle;
    public byte[] auth;

    public TPM2_PCR_SetAuthValue_REQUEST(TPM_HANDLE _pcrHandle, byte[] _auth) {
        this.pcrHandle = _pcrHandle;
        this.auth = _auth;
    }

    public TPM2_PCR_SetAuthValue_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.pcrHandle.toTpm(buf);
        buf.writeInt(this.auth != null ? this.auth.length : 0, 2);
        if (this.auth != null) {
            buf.write(this.auth);
        }
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.pcrHandle = TPM_HANDLE.fromTpm(buf);
        int _authSize = buf.readInt(2);
        this.auth = new byte[_authSize];
        buf.readArrayOfInts(this.auth, 1, _authSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_PCR_SetAuthValue_REQUEST fromTpm(byte[] x) {
        TPM2_PCR_SetAuthValue_REQUEST ret = new TPM2_PCR_SetAuthValue_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_PCR_SetAuthValue_REQUEST fromTpm(InByteBuf buf) {
        TPM2_PCR_SetAuthValue_REQUEST ret = new TPM2_PCR_SetAuthValue_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_PCR_SetAuthValue_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "pcrHandle", this.pcrHandle);
        _p.add(d, "byte", "auth", this.auth);
    }
}

