/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import java.util.Stack;
import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_ECC_POINT;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_HANDLE;

public class TPM2_ZGen_2Phase_REQUEST
extends TpmStructure {
    public TPM_HANDLE keyA;
    public TPMS_ECC_POINT inQsB;
    public TPMS_ECC_POINT inQeB;
    public TPM_ALG_ID inScheme;
    public short counter;

    public TPM2_ZGen_2Phase_REQUEST(TPM_HANDLE _keyA, TPMS_ECC_POINT _inQsB, TPMS_ECC_POINT _inQeB, TPM_ALG_ID _inScheme, int _counter) {
        this.keyA = _keyA;
        this.inQsB = _inQsB;
        this.inQeB = _inQeB;
        this.inScheme = _inScheme;
        this.counter = (short)_counter;
    }

    public TPM2_ZGen_2Phase_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.keyA.toTpm(buf);
        buf.writeInt(this.inQsB != null ? this.inQsB.toTpm().length : 0, 2);
        if (this.inQsB != null) {
            this.inQsB.toTpm(buf);
        }
        buf.writeInt(this.inQeB != null ? this.inQeB.toTpm().length : 0, 2);
        if (this.inQeB != null) {
            this.inQeB.toTpm(buf);
        }
        this.inScheme.toTpm(buf);
        buf.write(this.counter);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.keyA = TPM_HANDLE.fromTpm(buf);
        int _inQsBSize = buf.readInt(2);
        Stack<InByteBuf.SizedStructInfo> stack = buf.structSize;
        InByteBuf inByteBuf = buf;
        inByteBuf.getClass();
        stack.push(inByteBuf.new InByteBuf.SizedStructInfo(buf.curPos(), _inQsBSize));
        this.inQsB = TPMS_ECC_POINT.fromTpm(buf);
        buf.structSize.pop();
        int _inQeBSize = buf.readInt(2);
        Stack<InByteBuf.SizedStructInfo> stack2 = buf.structSize;
        InByteBuf inByteBuf2 = buf;
        inByteBuf2.getClass();
        stack2.push(inByteBuf2.new InByteBuf.SizedStructInfo(buf.curPos(), _inQeBSize));
        this.inQeB = TPMS_ECC_POINT.fromTpm(buf);
        buf.structSize.pop();
        this.inScheme = TPM_ALG_ID.fromTpm(buf);
        this.counter = (short)buf.readInt(2);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_ZGen_2Phase_REQUEST fromTpm(byte[] x) {
        TPM2_ZGen_2Phase_REQUEST ret = new TPM2_ZGen_2Phase_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_ZGen_2Phase_REQUEST fromTpm(InByteBuf buf) {
        TPM2_ZGen_2Phase_REQUEST ret = new TPM2_ZGen_2Phase_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_ZGen_2Phase_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "keyA", this.keyA);
        _p.add(d, "TPMS_ECC_POINT", "inQsB", this.inQsB);
        _p.add(d, "TPMS_ECC_POINT", "inQeB", this.inQeB);
        _p.add(d, "TPM_ALG_ID", "inScheme", this.inScheme);
        _p.add(d, "ushort", "counter", this.counter);
    }
}

