/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMA_ALGORITHM;
import tss.tpm.TPM_ALG_ID;

public class TPMS_ALG_PROPERTY
extends TpmStructure {
    public TPM_ALG_ID alg;
    public TPMA_ALGORITHM algProperties;

    public TPMS_ALG_PROPERTY(TPM_ALG_ID _alg, TPMA_ALGORITHM _algProperties) {
        this.alg = _alg;
        this.algProperties = _algProperties;
    }

    public TPMS_ALG_PROPERTY() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.alg.toTpm(buf);
        this.algProperties.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.alg = TPM_ALG_ID.fromTpm(buf);
        int _algProperties = buf.readInt(4);
        this.algProperties = TPMA_ALGORITHM.fromInt(_algProperties);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPMS_ALG_PROPERTY fromTpm(byte[] x) {
        TPMS_ALG_PROPERTY ret = new TPMS_ALG_PROPERTY();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPMS_ALG_PROPERTY fromTpm(InByteBuf buf) {
        TPMS_ALG_PROPERTY ret = new TPMS_ALG_PROPERTY();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_ALG_PROPERTY");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_ALG_ID", "alg", this.alg);
        _p.add(d, "TPMA_ALGORITHM", "algProperties", this.algProperties);
    }
}

