/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;

public class TPMS_CONTEXT_DATA
extends TpmStructure {
    public byte[] integrity;
    public byte[] encrypted;

    public TPMS_CONTEXT_DATA(byte[] _integrity, byte[] _encrypted) {
        this.integrity = _integrity;
        this.encrypted = _encrypted;
    }

    public TPMS_CONTEXT_DATA() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.integrity != null ? this.integrity.length : 0, 2);
        if (this.integrity != null) {
            buf.write(this.integrity);
        }
        buf.write(this.encrypted);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _integritySize = buf.readInt(2);
        this.integrity = new byte[_integritySize];
        buf.readArrayOfInts(this.integrity, 1, _integritySize);
        InByteBuf.SizedStructInfo si = buf.structSize.peek();
        int _encryptedSize = si.Size - (buf.curPos() - si.StartPos);
        this.encrypted = new byte[_encryptedSize];
        buf.readArrayOfInts(this.encrypted, 1, _encryptedSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPMS_CONTEXT_DATA fromTpm(byte[] x) {
        TPMS_CONTEXT_DATA ret = new TPMS_CONTEXT_DATA();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPMS_CONTEXT_DATA fromTpm(InByteBuf buf) {
        TPMS_CONTEXT_DATA ret = new TPMS_CONTEXT_DATA();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_CONTEXT_DATA");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "byte", "integrity", this.integrity);
        _p.add(d, "byte", "encrypted", this.encrypted);
    }
}

