/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMU_ATTEST;

public class TPMS_CREATION_INFO
extends TpmStructure
implements TPMU_ATTEST {
    public byte[] objectName;
    public byte[] creationHash;

    public TPMS_CREATION_INFO(byte[] _objectName, byte[] _creationHash) {
        this.objectName = _objectName;
        this.creationHash = _creationHash;
    }

    public TPMS_CREATION_INFO() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.objectName != null ? this.objectName.length : 0, 2);
        if (this.objectName != null) {
            buf.write(this.objectName);
        }
        buf.writeInt(this.creationHash != null ? this.creationHash.length : 0, 2);
        if (this.creationHash != null) {
            buf.write(this.creationHash);
        }
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _objectNameSize = buf.readInt(2);
        this.objectName = new byte[_objectNameSize];
        buf.readArrayOfInts(this.objectName, 1, _objectNameSize);
        int _creationHashSize = buf.readInt(2);
        this.creationHash = new byte[_creationHashSize];
        buf.readArrayOfInts(this.creationHash, 1, _creationHashSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPMS_CREATION_INFO fromTpm(byte[] x) {
        TPMS_CREATION_INFO ret = new TPMS_CREATION_INFO();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPMS_CREATION_INFO fromTpm(InByteBuf buf) {
        TPMS_CREATION_INFO ret = new TPMS_CREATION_INFO();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_CREATION_INFO");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "byte", "objectName", this.objectName);
        _p.add(d, "byte", "creationHash", this.creationHash);
    }
}

