/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_PT_PCR;

public class TPMS_TAGGED_PCR_SELECT
extends TpmStructure {
    public TPM_PT_PCR tag;
    public byte[] pcrSelect;

    public TPMS_TAGGED_PCR_SELECT(TPM_PT_PCR _tag, byte[] _pcrSelect) {
        this.tag = _tag;
        this.pcrSelect = _pcrSelect;
    }

    public TPMS_TAGGED_PCR_SELECT() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.tag.toTpm(buf);
        buf.writeInt(this.pcrSelect != null ? this.pcrSelect.length : 0, 1);
        if (this.pcrSelect != null) {
            buf.write(this.pcrSelect);
        }
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.tag = TPM_PT_PCR.fromTpm(buf);
        int _sizeofSelect = buf.readInt(1);
        this.pcrSelect = new byte[_sizeofSelect];
        buf.readArrayOfInts(this.pcrSelect, 1, _sizeofSelect);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPMS_TAGGED_PCR_SELECT fromTpm(byte[] x) {
        TPMS_TAGGED_PCR_SELECT ret = new TPMS_TAGGED_PCR_SELECT();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPMS_TAGGED_PCR_SELECT fromTpm(InByteBuf buf) {
        TPMS_TAGGED_PCR_SELECT ret = new TPMS_TAGGED_PCR_SELECT();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_TAGGED_PCR_SELECT");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_PT_PCR", "tag", this.tag);
        _p.add(d, "byte", "pcrSelect", this.pcrSelect);
    }
}

