/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_NULL_KDF_SCHEME;
import tss.tpm.TPMS_SCHEME_KDF1_SP800_108;
import tss.tpm.TPMS_SCHEME_KDF1_SP800_56A;
import tss.tpm.TPMS_SCHEME_KDF2;
import tss.tpm.TPMS_SCHEME_MGF1;
import tss.tpm.TPMU_KDF_SCHEME;
import tss.tpm.TPM_ALG_ID;

public class TPMT_KDF_SCHEME
extends TpmStructure {
    public TPMU_KDF_SCHEME details;

    public TPMT_KDF_SCHEME(TPMU_KDF_SCHEME _details) {
        this.details = _details;
    }

    public TPMT_KDF_SCHEME() {
    }

    public int GetUnionSelector_details() {
        if (this.details instanceof TPMS_SCHEME_MGF1) {
            return 7;
        }
        if (this.details instanceof TPMS_SCHEME_KDF1_SP800_56A) {
            return 32;
        }
        if (this.details instanceof TPMS_SCHEME_KDF2) {
            return 33;
        }
        if (this.details instanceof TPMS_SCHEME_KDF1_SP800_108) {
            return 34;
        }
        if (this.details instanceof TPMS_NULL_KDF_SCHEME) {
            return 16;
        }
        throw new RuntimeException("Unrecognized type");
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.GetUnionSelector_details(), 2);
        this.details.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _scheme = buf.readInt(2);
        this.details = null;
        if (_scheme == TPM_ALG_ID.MGF1.toInt()) {
            this.details = new TPMS_SCHEME_MGF1();
        } else if (_scheme == TPM_ALG_ID.KDF1_SP800_56A.toInt()) {
            this.details = new TPMS_SCHEME_KDF1_SP800_56A();
        } else if (_scheme == TPM_ALG_ID.KDF2.toInt()) {
            this.details = new TPMS_SCHEME_KDF2();
        } else if (_scheme == TPM_ALG_ID.KDF1_SP800_108.toInt()) {
            this.details = new TPMS_SCHEME_KDF1_SP800_108();
        } else if (_scheme == TPM_ALG_ID.NULL.toInt()) {
            this.details = new TPMS_NULL_KDF_SCHEME();
        }
        if (this.details == null) {
            throw new RuntimeException("Unexpected type selector " + TPM_ALG_ID.fromInt(_scheme).name());
        }
        this.details.initFromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPMT_KDF_SCHEME fromTpm(byte[] x) {
        TPMT_KDF_SCHEME ret = new TPMT_KDF_SCHEME();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPMT_KDF_SCHEME fromTpm(InByteBuf buf) {
        TPMT_KDF_SCHEME ret = new TPMT_KDF_SCHEME();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMT_KDF_SCHEME");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPMU_KDF_SCHEME", "details", this.details);
    }
}

