/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import java.util.Stack;
import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMT_SENSITIVE;

public class _PRIVATE
extends TpmStructure {
    public byte[] integrityOuter;
    public byte[] integrityInner;
    public TPMT_SENSITIVE sensitive;

    public _PRIVATE(byte[] _integrityOuter, byte[] _integrityInner, TPMT_SENSITIVE _sensitive) {
        this.integrityOuter = _integrityOuter;
        this.integrityInner = _integrityInner;
        this.sensitive = _sensitive;
    }

    public _PRIVATE() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.integrityOuter != null ? this.integrityOuter.length : 0, 2);
        if (this.integrityOuter != null) {
            buf.write(this.integrityOuter);
        }
        buf.writeInt(this.integrityInner != null ? this.integrityInner.length : 0, 2);
        if (this.integrityInner != null) {
            buf.write(this.integrityInner);
        }
        buf.writeInt(this.sensitive != null ? this.sensitive.toTpm().length : 0, 2);
        if (this.sensitive != null) {
            this.sensitive.toTpm(buf);
        }
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _integrityOuterSize = buf.readInt(2);
        this.integrityOuter = new byte[_integrityOuterSize];
        buf.readArrayOfInts(this.integrityOuter, 1, _integrityOuterSize);
        int _integrityInnerSize = buf.readInt(2);
        this.integrityInner = new byte[_integrityInnerSize];
        buf.readArrayOfInts(this.integrityInner, 1, _integrityInnerSize);
        int _sensitiveSize = buf.readInt(2);
        Stack<InByteBuf.SizedStructInfo> stack = buf.structSize;
        InByteBuf inByteBuf = buf;
        inByteBuf.getClass();
        stack.push(inByteBuf.new InByteBuf.SizedStructInfo(buf.curPos(), _sensitiveSize));
        this.sensitive = TPMT_SENSITIVE.fromTpm(buf);
        buf.structSize.pop();
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static _PRIVATE fromTpm(byte[] x) {
        _PRIVATE ret = new _PRIVATE();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static _PRIVATE fromTpm(InByteBuf buf) {
        _PRIVATE ret = new _PRIVATE();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("_PRIVATE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "byte", "integrityOuter", this.integrityOuter);
        _p.add(d, "byte", "integrityInner", this.integrityInner);
        _p.add(d, "TPMT_SENSITIVE", "sensitive", this.sensitive);
    }
}

