/*
 * Decompiled with CFR 0.152.
 */
package com.github.nitram509.jmacaroons;

import com.github.nitram509.jmacaroons.MacaroonsConstants;
import com.github.nitram509.jmacaroons.util.Base64;
import java.io.Serializable;
import java.util.Arrays;

public class CaveatPacket
implements Serializable {
    public final Type type;
    public final byte[] rawValue;
    private String valueAsText;

    CaveatPacket(Type type, byte[] rawValue) {
        assert (type != null);
        assert (rawValue != null);
        this.type = type;
        this.rawValue = rawValue;
    }

    CaveatPacket(Type type, String valueAsText) {
        assert (type != null);
        assert (type != Type.vid) : "VIDs should be used as raw bytes, because otherwise UTF8 string encoder would break it";
        assert (valueAsText != null);
        this.type = type;
        this.rawValue = valueAsText.getBytes(MacaroonsConstants.IDENTIFIER_CHARSET);
    }

    public Type getType() {
        return this.type;
    }

    public byte[] getRawValue() {
        return this.rawValue;
    }

    public String getValueAsText() {
        if (this.type == Type.vid) {
            if (this.valueAsText == null) {
                this.valueAsText = Base64.encodeUrlSafeToString(this.rawValue);
            }
            return this.valueAsText;
        }
        return new String(this.rawValue, MacaroonsConstants.IDENTIFIER_CHARSET);
    }

    public String toString() {
        return this.type.name() + ' ' + Arrays.toString(this.rawValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CaveatPacket that = (CaveatPacket)o;
        if (!Arrays.equals(this.rawValue, that.rawValue)) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.rawValue != null ? Arrays.hashCode(this.rawValue) : 0);
        return result;
    }

    public static enum Type {
        location,
        identifier,
        signature,
        cid,
        vid,
        cl;

    }
}

