/*
 * Decompiled with CFR 0.152.
 */
package com.github.nitram509.jmacaroons;

import com.github.nitram509.jmacaroons.GeneralSecurityRuntimeException;
import com.github.nitram509.jmacaroons.MacaroonsConstants;
import com.github.nitram509.jmacaroons.crypto.neilalexander.jnacl.xsalsa20poly1305;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

class CryptoTools {
    private static final String HMAC_SHA_256_ALGO = "HmacSHA256";
    private static final String MACAROONS_MAGIC_KEY = "macaroons-key-generator";
    private static final Mac HMACSHA256_PROTOTYPE;

    CryptoTools() {
    }

    static byte[] generate_derived_key(String variableKey) throws InvalidKeyException, NoSuchAlgorithmException {
        return CryptoTools.macaroon_hmac(MACAROONS_MAGIC_KEY.getBytes(MacaroonsConstants.IDENTIFIER_CHARSET), variableKey);
    }

    static byte[] macaroon_hmac(byte[] key, String message) throws NoSuchAlgorithmException, InvalidKeyException {
        return CryptoTools.macaroon_hmac(key, message.getBytes(MacaroonsConstants.IDENTIFIER_CHARSET));
    }

    static byte[] macaroon_hmac(byte[] key, byte[] message) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac sha256HMAC = CryptoTools.createNewHmacInstance();
        SecretKeySpec secret_key = new SecretKeySpec(key, HMAC_SHA_256_ALGO);
        sha256HMAC.init(secret_key);
        return sha256HMAC.doFinal(message);
    }

    static byte[] macaroon_hash2(byte[] key, byte[] message1, byte[] message2) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] tmp = new byte[64];
        System.arraycopy(CryptoTools.macaroon_hmac(key, message1), 0, tmp, 0, 32);
        System.arraycopy(CryptoTools.macaroon_hmac(key, message2), 0, tmp, 32, 32);
        return CryptoTools.macaroon_hmac(key, tmp);
    }

    static ThirdPartyPacket macaroon_add_third_party_caveat_raw(byte[] old_sig, String key, String identifier) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] derived_key = CryptoTools.generate_derived_key(key);
        byte[] enc_nonce = new byte[24];
        byte[] enc_plaintext = new byte[64];
        byte[] enc_ciphertext = new byte[64];
        System.arraycopy(derived_key, 0, enc_plaintext, 32, 32);
        CryptoTools.macaroon_secretbox(old_sig, enc_nonce, enc_plaintext, enc_ciphertext);
        byte[] vid = new byte[72];
        System.arraycopy(enc_nonce, 0, vid, 0, 24);
        System.arraycopy(enc_ciphertext, 16, vid, 24, 48);
        byte[] new_sig = CryptoTools.macaroon_hash2(old_sig, vid, identifier.getBytes(MacaroonsConstants.IDENTIFIER_CHARSET));
        return new ThirdPartyPacket(new_sig, vid);
    }

    static byte[] macaroon_bind(byte[] Msig, byte[] MPsig) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] key = new byte[32];
        return CryptoTools.macaroon_hash2(key, Msig, MPsig);
    }

    private static void macaroon_secretbox(byte[] key, byte[] nonce, byte[] plaintext, byte[] ciphertext) throws GeneralSecurityRuntimeException {
        int err_code = xsalsa20poly1305.crypto_secretbox(ciphertext, plaintext, plaintext.length, nonce, key);
        if (err_code != 0) {
            throw new GeneralSecurityRuntimeException("Error while creating secret box. err_code=" + err_code);
        }
    }

    private static Mac createNewHmacInstance() throws NoSuchAlgorithmException {
        try {
            Mac clonedMac = (Mac)HMACSHA256_PROTOTYPE.clone();
            clonedMac.reset();
            return clonedMac;
        }
        catch (CloneNotSupportedException e) {
            return Mac.getInstance(HMAC_SHA_256_ALGO);
        }
    }

    static {
        try {
            HMACSHA256_PROTOTYPE = Mac.getInstance(HMAC_SHA_256_ALGO);
        }
        catch (NoSuchAlgorithmException e) {
            throw new GeneralSecurityRuntimeException(e);
        }
    }

    static class ThirdPartyPacket {
        final byte[] signature;
        final byte[] vid_data;

        ThirdPartyPacket(byte[] signature, byte[] vid_data) {
            this.signature = signature;
            this.vid_data = vid_data;
        }
    }
}

