/*
 * Decompiled with CFR 0.152.
 */
package com.github.nitram509.jmacaroons;

import com.github.nitram509.jmacaroons.CaveatPacket;
import com.github.nitram509.jmacaroons.MacaroonsSerializer;
import com.github.nitram509.jmacaroons.util.BinHex;
import java.io.Serializable;
import java.util.Arrays;

public class Macaroon
implements Serializable {
    public final String location;
    public final String identifier;
    public final String signature;
    public final CaveatPacket[] caveatPackets;
    final byte[] signatureBytes;

    Macaroon(String location, String identifier, byte[] signature) {
        this(location, identifier, new CaveatPacket[0], signature);
    }

    Macaroon(String location, String identifier, CaveatPacket[] caveats, byte[] signature) {
        this.location = location;
        this.identifier = identifier;
        this.caveatPackets = caveats;
        this.signature = BinHex.bin2hex(signature);
        this.signatureBytes = signature;
    }

    public String inspect() {
        return this.createKeyValuePacket(CaveatPacket.Type.location, this.location) + this.createKeyValuePacket(CaveatPacket.Type.identifier, this.identifier) + this.createCaveatsPackets(this.caveatPackets) + this.createKeyValuePacket(CaveatPacket.Type.signature, this.signature);
    }

    private String createCaveatsPackets(CaveatPacket[] caveats) {
        if (caveats == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (CaveatPacket packet : caveats) {
            sb.append(this.createKeyValuePacket(packet.type, packet.getValueAsText()));
        }
        return sb.toString();
    }

    private String createKeyValuePacket(CaveatPacket.Type type, String value) {
        return value != null ? type.name() + ' ' + value + '\n' : "";
    }

    public String serialize() {
        return MacaroonsSerializer.serialize(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Macaroon macaroon = (Macaroon)o;
        if (!Arrays.equals(this.caveatPackets, macaroon.caveatPackets)) {
            return false;
        }
        if (this.identifier != null ? !this.identifier.equals(macaroon.identifier) : macaroon.identifier != null) {
            return false;
        }
        if (this.location != null ? !this.location.equals(macaroon.location) : macaroon.location != null) {
            return false;
        }
        return !(this.signature != null ? !this.signature.equals(macaroon.signature) : macaroon.signature != null);
    }

    public int hashCode() {
        int result = this.location != null ? this.location.hashCode() : 0;
        result = 31 * result + (this.identifier != null ? this.identifier.hashCode() : 0);
        result = 31 * result + (this.signature != null ? this.signature.hashCode() : 0);
        result = 31 * result + (this.caveatPackets != null ? Arrays.hashCode(this.caveatPackets) : 0);
        return result;
    }
}

