/*
 * Decompiled with CFR 0.152.
 */
package com.github.nitram509.jmacaroons;

import com.github.nitram509.jmacaroons.CaveatPacket;
import com.github.nitram509.jmacaroons.CryptoTools;
import com.github.nitram509.jmacaroons.GeneralSecurityRuntimeException;
import com.github.nitram509.jmacaroons.Macaroon;
import com.github.nitram509.jmacaroons.MacaroonsConstants;
import com.github.nitram509.jmacaroons.MacaroonsDeSerializer;
import com.github.nitram509.jmacaroons.util.ArrayTools;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

public class MacaroonsBuilder {
    private Macaroon macaroon = null;

    public MacaroonsBuilder(String location, String secretKey, String identifier) throws GeneralSecurityRuntimeException {
        this.macaroon = MacaroonsBuilder.computeMacaroon(location, secretKey, identifier);
    }

    public MacaroonsBuilder(String location, byte[] secretKey, String identifier) throws GeneralSecurityRuntimeException {
        this.macaroon = MacaroonsBuilder.computeMacaroon(location, secretKey, identifier);
    }

    public MacaroonsBuilder(Macaroon macaroon) {
        assert (macaroon != null);
        this.macaroon = macaroon;
    }

    public static Macaroon create(String location, String secretKey, String identifier) {
        return MacaroonsBuilder.computeMacaroon(location, secretKey, identifier);
    }

    public static Macaroon create(String location, byte[] secretKey, String identifier) {
        return MacaroonsBuilder.computeMacaroon(location, secretKey, identifier);
    }

    public static MacaroonsBuilder modify(Macaroon macaroon) {
        return new MacaroonsBuilder(macaroon);
    }

    public static Macaroon deserialize(String serializedMacaroon) throws IllegalArgumentException {
        return MacaroonsDeSerializer.deserialize(serializedMacaroon);
    }

    public Macaroon getMacaroon() {
        return this.macaroon;
    }

    public MacaroonsBuilder add_first_party_caveat(String caveat) throws IllegalStateException, GeneralSecurityRuntimeException {
        if (caveat != null) {
            byte[] caveatBytes = caveat.getBytes(MacaroonsConstants.IDENTIFIER_CHARSET);
            assert (caveatBytes.length < 32768);
            if (this.macaroon.caveatPackets.length + 1 > 65536) {
                throw new IllegalStateException("Too many caveats. There are max. 65536 caveats allowed.");
            }
            try {
                byte[] signature = CryptoTools.macaroon_hmac(this.macaroon.signatureBytes, caveatBytes);
                CaveatPacket[] caveatsAppended = ArrayTools.appendToArray(this.macaroon.caveatPackets, new CaveatPacket(CaveatPacket.Type.cid, caveatBytes));
                this.macaroon = new Macaroon(this.macaroon.location, this.macaroon.identifier, caveatsAppended, signature);
            }
            catch (InvalidKeyException e) {
                throw new GeneralSecurityRuntimeException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new GeneralSecurityRuntimeException(e);
            }
        }
        return this;
    }

    public MacaroonsBuilder add_third_party_caveat(String location, String secret, String identifier) throws IllegalStateException, GeneralSecurityRuntimeException {
        assert (location.length() < 32768);
        assert (identifier.length() < 32768);
        if (this.macaroon.caveatPackets.length + 1 > 65536) {
            throw new IllegalStateException("Too many caveats. There are max. 65536 caveats allowed.");
        }
        try {
            CryptoTools.ThirdPartyPacket thirdPartyPacket = CryptoTools.macaroon_add_third_party_caveat_raw(this.macaroon.signatureBytes, secret, identifier);
            byte[] hash = thirdPartyPacket.signature;
            CaveatPacket[] caveatsExtended = ArrayTools.appendToArray(this.macaroon.caveatPackets, new CaveatPacket(CaveatPacket.Type.cid, identifier), new CaveatPacket(CaveatPacket.Type.vid, thirdPartyPacket.vid_data), new CaveatPacket(CaveatPacket.Type.cl, location));
            this.macaroon = new Macaroon(this.macaroon.location, this.macaroon.identifier, caveatsExtended, hash);
        }
        catch (InvalidKeyException e) {
            throw new GeneralSecurityRuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new GeneralSecurityRuntimeException(e);
        }
        return this;
    }

    public MacaroonsBuilder prepare_for_request(Macaroon macaroon) throws GeneralSecurityRuntimeException {
        assert (macaroon.signatureBytes.length > 0);
        assert (this.getMacaroon().signatureBytes.length > 0);
        try {
            byte[] hash = CryptoTools.macaroon_bind(this.getMacaroon().signatureBytes, macaroon.signatureBytes);
            this.macaroon = new Macaroon(macaroon.location, macaroon.identifier, macaroon.caveatPackets, hash);
            return this;
        }
        catch (InvalidKeyException e) {
            throw new GeneralSecurityRuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new GeneralSecurityRuntimeException(e);
        }
    }

    private static Macaroon computeMacaroon(String location, String secretKey, String identifier) throws GeneralSecurityRuntimeException {
        try {
            return MacaroonsBuilder.computeMacaroon(location, CryptoTools.generate_derived_key(secretKey), identifier);
        }
        catch (InvalidKeyException e) {
            throw new GeneralSecurityRuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new GeneralSecurityRuntimeException(e);
        }
    }

    private static Macaroon computeMacaroon(String location, byte[] secretKey, String identifier) throws GeneralSecurityRuntimeException {
        assert (location.length() < 32768);
        assert (identifier.length() < 32768);
        try {
            byte[] hash = CryptoTools.macaroon_hmac(secretKey, identifier);
            return new Macaroon(location, identifier, hash);
        }
        catch (InvalidKeyException e) {
            throw new GeneralSecurityRuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new GeneralSecurityRuntimeException(e);
        }
    }
}

