/*
 * Decompiled with CFR 0.152.
 */
package com.github.nitram509.jmacaroons;

import com.github.nitram509.jmacaroons.CaveatPacket;
import com.github.nitram509.jmacaroons.Macaroon;
import com.github.nitram509.jmacaroons.MacaroonsConstants;
import com.github.nitram509.jmacaroons.NotDeSerializableException;
import com.github.nitram509.jmacaroons.util.Base64;
import java.util.ArrayList;

class MacaroonsDeSerializer {
    private static final byte[] HEX_ALPHABET = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 0, 0, 0, 0, 0, 0, 10, 11, 12, 13, 14, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 11, 12, 13, 14, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    MacaroonsDeSerializer() {
    }

    public static Macaroon deserialize(String serializedMacaroon) throws NotDeSerializableException {
        int minLength;
        assert (serializedMacaroon != null);
        byte[] bytes = Base64.decode(serializedMacaroon);
        if (bytes.length < (minLength = 33 + "signature".length())) {
            throw new NotDeSerializableException("Couldn't deserialize macaroon. Not enough bytes for signature found. There have to be at least " + minLength + " bytes");
        }
        return MacaroonsDeSerializer.deserializeStream(new StatefulPacketReader(bytes));
    }

    private static Macaroon deserializeStream(StatefulPacketReader packetReader) {
        Packet packet;
        String location = null;
        String identifier = null;
        ArrayList<CaveatPacket> caveats = new ArrayList<CaveatPacket>(3);
        byte[] signature = null;
        while ((packet = MacaroonsDeSerializer.readPacket(packetReader)) != null) {
            String s;
            if (MacaroonsDeSerializer.bytesStartWith(packet.data, MacaroonsConstants.LOCATION_BYTES)) {
                location = MacaroonsDeSerializer.parsePacket(packet, MacaroonsConstants.LOCATION_BYTES);
                continue;
            }
            if (MacaroonsDeSerializer.bytesStartWith(packet.data, MacaroonsConstants.IDENTIFIER_BYTES)) {
                identifier = MacaroonsDeSerializer.parsePacket(packet, MacaroonsConstants.IDENTIFIER_BYTES);
                continue;
            }
            if (MacaroonsDeSerializer.bytesStartWith(packet.data, MacaroonsConstants.CID_BYTES)) {
                s = MacaroonsDeSerializer.parsePacket(packet, MacaroonsConstants.CID_BYTES);
                caveats.add(new CaveatPacket(CaveatPacket.Type.cid, s));
                continue;
            }
            if (MacaroonsDeSerializer.bytesStartWith(packet.data, MacaroonsConstants.CL_BYTES)) {
                s = MacaroonsDeSerializer.parsePacket(packet, MacaroonsConstants.CL_BYTES);
                caveats.add(new CaveatPacket(CaveatPacket.Type.cl, s));
                continue;
            }
            if (MacaroonsDeSerializer.bytesStartWith(packet.data, MacaroonsConstants.VID_BYTES)) {
                byte[] raw = MacaroonsDeSerializer.parseRawPacket(packet, MacaroonsConstants.VID_BYTES);
                caveats.add(new CaveatPacket(CaveatPacket.Type.vid, raw));
                continue;
            }
            if (!MacaroonsDeSerializer.bytesStartWith(packet.data, MacaroonsConstants.SIGNATURE_BYTES)) continue;
            signature = MacaroonsDeSerializer.parseSignature(packet, MacaroonsConstants.SIGNATURE_BYTES);
        }
        return new Macaroon(location, identifier, caveats.toArray(new CaveatPacket[caveats.size()]), signature);
    }

    private static byte[] parseSignature(Packet packet, byte[] signaturePacketData) {
        int headerLen = signaturePacketData.length + 1;
        int len = Math.min(packet.data.length - headerLen, 32);
        byte[] signature = new byte[len];
        System.arraycopy(packet.data, headerLen, signature, 0, len);
        return signature;
    }

    private static String parsePacket(Packet packet, byte[] header) {
        int headerLen = header.length + 1;
        int len = packet.data.length - headerLen;
        if (packet.data[headerLen + len - 1] == 10) {
            --len;
        }
        return new String(packet.data, headerLen, len, MacaroonsConstants.IDENTIFIER_CHARSET);
    }

    private static byte[] parseRawPacket(Packet packet, byte[] header) {
        int headerLen = header.length + 1;
        int len = packet.data.length - headerLen - 1;
        byte[] raw = new byte[len];
        System.arraycopy(packet.data, headerLen, raw, 0, len);
        return raw;
    }

    private static boolean bytesStartWith(byte[] bytes, byte[] startBytes) {
        if (bytes.length < startBytes.length) {
            return false;
        }
        int len = startBytes.length;
        for (int i = 0; i < len; ++i) {
            if (bytes[i] == startBytes[i]) continue;
            return false;
        }
        return true;
    }

    private static Packet readPacket(StatefulPacketReader stream) {
        if (stream.isEOF()) {
            return null;
        }
        if (!stream.isPacketHeaderAvailable()) {
            throw new NotDeSerializableException("Not enough header bytes available. Needed 4 bytes.");
        }
        int size = stream.readPacketHeader();
        assert (size <= 65535);
        byte[] data = new byte[size - 4];
        int read = stream.read(data);
        if (read < 0) {
            return null;
        }
        if (read != data.length) {
            throw new NotDeSerializableException("Not enough data bytes available. Needed " + data.length + " bytes, but was only " + read);
        }
        return new Packet(size, data);
    }

    static class StatefulPacketReader {
        private final byte[] buffer;
        private int seekIndex = 0;

        public StatefulPacketReader(byte[] buffer) {
            this.buffer = buffer;
        }

        public int read(byte[] data) {
            int len = Math.min(data.length, this.buffer.length - this.seekIndex);
            if (len > 0) {
                System.arraycopy(this.buffer, this.seekIndex, data, 0, len);
                this.seekIndex += len;
                return len;
            }
            return -1;
        }

        public int readPacketHeader() {
            return HEX_ALPHABET[this.buffer[this.seekIndex++]] << 12 | HEX_ALPHABET[this.buffer[this.seekIndex++]] << 8 | HEX_ALPHABET[this.buffer[this.seekIndex++]] << 4 | HEX_ALPHABET[this.buffer[this.seekIndex++]];
        }

        public boolean isPacketHeaderAvailable() {
            return this.seekIndex <= this.buffer.length - 4;
        }

        public boolean isEOF() {
            return this.seekIndex >= this.buffer.length;
        }
    }

    private static class Packet {
        final int size;
        final byte[] data;

        private Packet(int size, byte[] data) {
            this.size = size;
            this.data = data;
        }
    }
}

