/*
 * Decompiled with CFR 0.152.
 */
package com.github.nitram509.jmacaroons;

import com.github.nitram509.jmacaroons.CaveatPacket;
import com.github.nitram509.jmacaroons.Macaroon;
import com.github.nitram509.jmacaroons.MacaroonsConstants;
import com.github.nitram509.jmacaroons.util.ArrayTools;
import com.github.nitram509.jmacaroons.util.Base64;
import java.util.ArrayList;

class MacaroonsSerializer {
    private static final byte[] HEX = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    MacaroonsSerializer() {
    }

    public static String serialize(Macaroon macaroon) {
        ArrayList<byte[]> packets = new ArrayList<byte[]>(3 + macaroon.caveatPackets.length);
        packets.add(MacaroonsSerializer.serialize_packet(CaveatPacket.Type.location, macaroon.location));
        packets.add(MacaroonsSerializer.serialize_packet(CaveatPacket.Type.identifier, macaroon.identifier));
        for (CaveatPacket caveatPacket : macaroon.caveatPackets) {
            packets.add(MacaroonsSerializer.serialize_packet(caveatPacket.type, caveatPacket.rawValue));
        }
        packets.add(MacaroonsSerializer.serialize_packet(CaveatPacket.Type.signature, macaroon.signatureBytes));
        return Base64.encodeUrlSafeToString(ArrayTools.flattenByteArray(packets));
    }

    private static byte[] serialize_packet(CaveatPacket.Type type, String data) {
        return MacaroonsSerializer.serialize_packet(type, data.getBytes(MacaroonsConstants.IDENTIFIER_CHARSET));
    }

    private static byte[] serialize_packet(CaveatPacket.Type type, byte[] data) {
        String typname = type.name();
        int packet_len = 4 + typname.length() + 1 + data.length + 1;
        byte[] packet = new byte[packet_len];
        int offset = 0;
        System.arraycopy(MacaroonsSerializer.packet_header(packet_len), 0, packet, offset, 4);
        System.arraycopy(typname.getBytes(), 0, packet, offset += 4, typname.length());
        packet[offset += typname.length()] = 32;
        System.arraycopy(data, 0, packet, ++offset, data.length);
        packet[offset += data.length] = 10;
        return packet;
    }

    private static byte[] packet_header(int size) {
        assert (size < 65536);
        byte[] packet = new byte[]{HEX[(size &= 0xFFFF) >> 12 & 0xF], HEX[size >> 8 & 0xF], HEX[size >> 4 & 0xF], HEX[size & 0xF]};
        return packet;
    }
}

