/*
 * Decompiled with CFR 0.152.
 */
package com.github.nitram509.jmacaroons;

import com.github.nitram509.jmacaroons.CaveatPacket;
import com.github.nitram509.jmacaroons.CryptoTools;
import com.github.nitram509.jmacaroons.GeneralCaveatVerifier;
import com.github.nitram509.jmacaroons.GeneralSecurityRuntimeException;
import com.github.nitram509.jmacaroons.Macaroon;
import com.github.nitram509.jmacaroons.MacaroonValidationException;
import com.github.nitram509.jmacaroons.crypto.neilalexander.jnacl.xsalsa20poly1305;
import com.github.nitram509.jmacaroons.util.ArrayTools;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MacaroonsVerifier {
    private String[] predicates = new String[0];
    private List<Macaroon> boundMacaroons = new ArrayList<Macaroon>(3);
    private GeneralCaveatVerifier[] generalCaveatVerifiers = new GeneralCaveatVerifier[0];
    private final Macaroon macaroon;

    public MacaroonsVerifier(Macaroon macaroon) {
        this.macaroon = macaroon;
    }

    public void assertIsValid(String secret) throws MacaroonValidationException, GeneralSecurityRuntimeException {
        try {
            this.assertIsValid(CryptoTools.generate_derived_key(secret));
        }
        catch (InvalidKeyException e) {
            throw new GeneralSecurityRuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new GeneralSecurityRuntimeException(e);
        }
    }

    public void assertIsValid(byte[] secret) throws MacaroonValidationException, GeneralSecurityRuntimeException {
        try {
            VerificationResult result = this.isValid_verify_raw(this.macaroon, secret);
            if (result.fail) {
                String msg = result.failMessage != null ? result.failMessage : "This macaroon isn't valid.";
                throw new MacaroonValidationException(msg, this.macaroon);
            }
        }
        catch (InvalidKeyException e) {
            throw new GeneralSecurityRuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new GeneralSecurityRuntimeException(e);
        }
    }

    public boolean isValid(String secret) throws GeneralSecurityRuntimeException {
        try {
            return this.isValid(CryptoTools.generate_derived_key(secret));
        }
        catch (InvalidKeyException e) {
            throw new GeneralSecurityRuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new GeneralSecurityRuntimeException(e);
        }
    }

    public boolean isValid(byte[] secret) throws GeneralSecurityRuntimeException {
        try {
            return !this.isValid_verify_raw((Macaroon)this.macaroon, (byte[])secret).fail;
        }
        catch (InvalidKeyException e) {
            throw new GeneralSecurityRuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new GeneralSecurityRuntimeException(e);
        }
    }

    private VerificationResult isValid_verify_raw(Macaroon M, byte[] secret) throws NoSuchAlgorithmException, InvalidKeyException {
        VerificationResult vresult = this.macaroon_verify_inner(M, secret);
        if (!vresult.fail) {
            boolean bl = vresult.fail = !Arrays.equals(vresult.csig, this.getMacaroon().signatureBytes);
            if (vresult.fail) {
                vresult = new VerificationResult("Verification failed. Signature doesn't match. Maybe the key was wrong OR some caveats aren't satisfied.");
            }
        }
        return vresult;
    }

    private VerificationResult macaroon_verify_inner(Macaroon M, byte[] key) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] csig = CryptoTools.macaroon_hmac(key, M.identifier);
        if (M.caveatPackets != null) {
            CaveatPacket[] caveatPackets = M.caveatPackets;
            for (int i = 0; i < caveatPackets.length; ++i) {
                String msg;
                CaveatPacket caveat = caveatPackets[i];
                if (caveat == null || caveat.type == CaveatPacket.Type.cl) continue;
                if (caveat.type != CaveatPacket.Type.cid || caveatPackets[Math.min((int)(i + 1), (int)(caveatPackets.length - 1))].type != CaveatPacket.Type.vid) {
                    if (!ArrayTools.containsElement(this.predicates, caveat.getValueAsText()) && !this.verifiesGeneral(caveat.getValueAsText())) continue;
                    csig = CryptoTools.macaroon_hmac(csig, caveat.rawValue);
                    continue;
                }
                CaveatPacket caveat_vid = caveatPackets[++i];
                Macaroon boundMacaroon = this.findBoundMacaroon(caveat.getValueAsText());
                if (boundMacaroon == null) {
                    msg = "Couldn't verify 3rd party macaroon, because no discharged macaroon was provided to the verifier.";
                    return new VerificationResult(msg);
                }
                if (!this.macaroon_verify_inner_3rd(boundMacaroon, caveat_vid, csig)) {
                    msg = "Couldn't verify 3rd party macaroon, identifier= " + boundMacaroon.identifier;
                    return new VerificationResult(msg);
                }
                byte[] data = caveat.rawValue;
                byte[] vdata = caveat_vid.rawValue;
                csig = CryptoTools.macaroon_hash2(csig, vdata, data);
            }
        }
        return new VerificationResult(csig);
    }

    private boolean macaroon_verify_inner_3rd(Macaroon M, CaveatPacket C, byte[] sig) throws InvalidKeyException, NoSuchAlgorithmException {
        if (M == null) {
            return false;
        }
        byte[] enc_plaintext = new byte[64];
        byte[] enc_ciphertext = new byte[64];
        byte[] vid_data = C.rawValue;
        assert (vid_data.length == 72);
        byte[] enc_nonce = vid_data;
        System.arraycopy(vid_data, 24, enc_ciphertext, 16, vid_data.length - 24);
        boolean valid = 0 == MacaroonsVerifier.macaroon_secretbox_open(sig, enc_nonce, enc_ciphertext, enc_ciphertext.length, enc_plaintext);
        byte[] key = new byte[32];
        System.arraycopy(enc_plaintext, 32, key, 0, 32);
        VerificationResult vresult = this.macaroon_verify_inner(M, key);
        byte[] data = this.getMacaroon().signatureBytes;
        byte[] csig = CryptoTools.macaroon_bind(data, vresult.csig);
        return valid && Arrays.equals(csig, M.signatureBytes);
    }

    private Macaroon findBoundMacaroon(String identifier) {
        for (Macaroon boundMacaroon : this.boundMacaroons) {
            if (!identifier.equals(boundMacaroon.identifier)) continue;
            return boundMacaroon;
        }
        return null;
    }

    private static int macaroon_secretbox_open(byte[] enc_key, byte[] enc_nonce, byte[] ciphertext, int ciphertext_sz, byte[] plaintext) {
        return xsalsa20poly1305.crypto_secretbox_open(plaintext, ciphertext, ciphertext_sz, enc_nonce, enc_key);
    }

    private boolean verifiesGeneral(String caveat) {
        boolean found = false;
        for (GeneralCaveatVerifier verifier : this.generalCaveatVerifiers) {
            found |= verifier.verifyCaveat(caveat);
        }
        return found;
    }

    public MacaroonsVerifier satisfyExcact(String caveat) {
        if (caveat != null) {
            this.predicates = ArrayTools.appendToArray(this.predicates, caveat);
        }
        return this;
    }

    public MacaroonsVerifier satisfy3rdParty(Macaroon preparedMacaroon) {
        if (preparedMacaroon != null) {
            this.boundMacaroons.add(preparedMacaroon);
        }
        return this;
    }

    public MacaroonsVerifier satisfyGeneral(GeneralCaveatVerifier verifier) {
        if (verifier != null) {
            this.generalCaveatVerifiers = ArrayTools.appendToArray(this.generalCaveatVerifiers, verifier);
        }
        return this;
    }

    public Macaroon getMacaroon() {
        return this.macaroon;
    }

    private static class VerificationResult {
        byte[] csig = null;
        boolean fail = false;
        String failMessage = null;

        private VerificationResult(byte[] csig) {
            this.csig = csig;
        }

        private VerificationResult(String failMessage) {
            this.failMessage = failMessage;
            this.fail = true;
        }
    }
}

