/*
 * Decompiled with CFR 0.152.
 */
package com.github.nitram509.jmacaroons.util;

import com.github.nitram509.jmacaroons.CaveatPacket;
import com.github.nitram509.jmacaroons.GeneralCaveatVerifier;
import java.util.List;

public class ArrayTools {
    public static CaveatPacket[] appendToArray(CaveatPacket[] elements, CaveatPacket ... newElements) {
        assert (newElements != null);
        CaveatPacket[] tmp = new CaveatPacket[elements.length + newElements.length];
        System.arraycopy(elements, 0, tmp, 0, elements.length);
        System.arraycopy(newElements, 0, tmp, elements.length, newElements.length);
        return tmp;
    }

    public static String[] appendToArray(String[] elements, String newElement) {
        assert (newElement != null);
        String[] tmp = new String[elements.length + 1];
        System.arraycopy(elements, 0, tmp, 0, elements.length);
        tmp[elements.length] = newElement;
        return tmp;
    }

    public static GeneralCaveatVerifier[] appendToArray(GeneralCaveatVerifier[] elements, GeneralCaveatVerifier newElement) {
        assert (newElement != null);
        GeneralCaveatVerifier[] tmp = new GeneralCaveatVerifier[elements.length + 1];
        System.arraycopy(elements, 0, tmp, 0, elements.length);
        tmp[elements.length] = newElement;
        return tmp;
    }

    public static boolean containsElement(String[] elements, String anElement) {
        if (elements != null) {
            for (String element : elements) {
                if (!element.equals(anElement)) continue;
                return true;
            }
        }
        return false;
    }

    public static byte[] flattenByteArray(List<byte[]> packets) {
        int size = 0;
        for (byte[] packet : packets) {
            size += packet.length;
        }
        byte[] alldata = new byte[size];
        size = 0;
        for (byte[] packet : packets) {
            System.arraycopy(packet, 0, alldata, size, packet.length);
            size += packet.length;
        }
        return alldata;
    }
}

