/*
 * Decompiled with CFR 0.152.
 */
package com.github.nitram509.jmacaroons.verifier;

import com.github.nitram509.jmacaroons.GeneralCaveatVerifier;
import java.util.HashSet;

public class AuthoritiesCaveatVerifier
implements GeneralCaveatVerifier {
    public static final String CAVEAT_PREFIX = "authorities =";
    private String[] requestedAuthorities;

    public AuthoritiesCaveatVerifier(String ... requestedAuthorities) {
        this.requestedAuthorities = requestedAuthorities != null ? requestedAuthorities : new String[]{};
    }

    public static AuthoritiesCaveatVerifier hasAuthority(String ... requestedAuthorities) {
        return new AuthoritiesCaveatVerifier(requestedAuthorities);
    }

    @Override
    public boolean verifyCaveat(String caveat) {
        boolean containsGivenAuthorities = false;
        if (caveat.startsWith(CAVEAT_PREFIX)) {
            HashSet<String> cavaetAuthorities = this.asTrimmedSet(caveat.substring(CAVEAT_PREFIX.length()).split("[,]"));
            containsGivenAuthorities = this.requestedAuthorities.length > 0;
            for (String authority : this.requestedAuthorities) {
                containsGivenAuthorities = containsGivenAuthorities && cavaetAuthorities.contains(authority);
            }
        }
        return containsGivenAuthorities;
    }

    private HashSet<String> asTrimmedSet(String[] cavaetAuthorities) {
        HashSet<String> result = new HashSet<String>(cavaetAuthorities.length);
        for (String cavaetAuthority : cavaetAuthorities) {
            result.add(cavaetAuthority.trim());
        }
        return result;
    }
}

