/*
 * Decompiled with CFR 0.152.
 */
package com.github.nitram509.jmacaroons.verifier;

import com.github.nitram509.jmacaroons.GeneralCaveatVerifier;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class TimestampCaveatVerifier
implements GeneralCaveatVerifier {
    public static final String CAVEAT_PREFIX = "time < ";
    public static final int CAVEAT_PREFIX_LEN = "time < ".length();
    private static SimpleDateFormat ISO_DateFormat_DAY = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat ISO_DateFormat_HOUR = new SimpleDateFormat("yyyy-MM-dd'T'HH");
    private static SimpleDateFormat ISO_DateFormat_MINUTE = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
    private static SimpleDateFormat ISO_DateFormat_SECOND = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static SimpleDateFormat ISO_DateFormat_TIMEZONE = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    @Override
    public boolean verifyCaveat(String caveat) {
        if (caveat.startsWith(CAVEAT_PREFIX)) {
            Date parsedDate = ISO_DateFormat_TIMEZONE.parse(caveat, new ParsePosition(CAVEAT_PREFIX_LEN));
            if (parsedDate == null) {
                parsedDate = ISO_DateFormat_SECOND.parse(caveat, new ParsePosition(CAVEAT_PREFIX_LEN));
            }
            if (parsedDate == null) {
                parsedDate = ISO_DateFormat_MINUTE.parse(caveat, new ParsePosition(CAVEAT_PREFIX_LEN));
            }
            if (parsedDate == null) {
                parsedDate = ISO_DateFormat_HOUR.parse(caveat, new ParsePosition(CAVEAT_PREFIX_LEN));
            }
            if (parsedDate == null) {
                parsedDate = ISO_DateFormat_DAY.parse(caveat, new ParsePosition(CAVEAT_PREFIX_LEN));
            }
            Date now = Calendar.getInstance().getTime();
            return parsedDate != null && now.before(parsedDate);
        }
        return false;
    }
}

