/*
 * Decompiled with CFR 0.152.
 */
package com.github.palindromicity.syslog;

import com.github.palindromicity.syslog.AbstractSyslogParser;
import com.github.palindromicity.syslog.AllowableDeviations;
import com.github.palindromicity.syslog.KeyProvider;
import com.github.palindromicity.syslog.dsl.DefaultErrorListener;
import com.github.palindromicity.syslog.dsl.Syslog3164Listener;
import com.github.palindromicity.syslog.dsl.generated.Rfc3164Lexer;
import com.github.palindromicity.syslog.dsl.generated.Rfc3164Parser;
import com.github.palindromicity.syslog.util.Validate;
import java.util.EnumSet;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

class Rfc3164SyslogParser
extends AbstractSyslogParser {
    Rfc3164SyslogParser(KeyProvider keyProvider, EnumSet<AllowableDeviations> deviations) {
        super(keyProvider, deviations);
    }

    @Override
    public Map<String, Object> parseLine(String syslogLine) {
        Validate.notBlank(syslogLine, "syslogLine");
        Rfc3164Lexer lexer = new Rfc3164Lexer((CharStream)new ANTLRInputStream(syslogLine));
        lexer.removeErrorListeners();
        lexer.addErrorListener(new DefaultErrorListener());
        Rfc3164Parser parser = new Rfc3164Parser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        Syslog3164Listener listener = new Syslog3164Listener(this.getKeyProvider(), this.getDeviations());
        parser.addParseListener(listener);
        parser.removeErrorListeners();
        parser.addErrorListener(new DefaultErrorListener());
        parser.syslog_msg();
        return listener.getMessageMap();
    }
}

