/*
 * Decompiled with CFR 0.152.
 */
package com.github.palindromicity.syslog;

import com.github.palindromicity.syslog.AllowableDeviations;
import com.github.palindromicity.syslog.DefaultKeyProvider;
import com.github.palindromicity.syslog.KeyProvider;
import com.github.palindromicity.syslog.NilPolicy;
import com.github.palindromicity.syslog.Rfc3164SyslogParser;
import com.github.palindromicity.syslog.Rfc5424SyslogParser;
import com.github.palindromicity.syslog.StructuredDataPolicy;
import com.github.palindromicity.syslog.SyslogParser;
import com.github.palindromicity.syslog.SyslogSpecification;
import java.util.EnumSet;

public class SyslogParserBuilder {
    private EnumSet<AllowableDeviations> deviations = EnumSet.of(AllowableDeviations.NONE);
    private KeyProvider keyProvider = new DefaultKeyProvider();
    private NilPolicy nilPolicy = NilPolicy.OMIT;
    private StructuredDataPolicy structuredDataPolicy = StructuredDataPolicy.FLATTEN;
    private SyslogSpecification specification = SyslogSpecification.RFC_5424;

    public SyslogParserBuilder forSpecification(SyslogSpecification specification) {
        this.specification = specification;
        return this;
    }

    public SyslogParserBuilder withDeviations(EnumSet<AllowableDeviations> deviations) {
        this.deviations = deviations;
        return this;
    }

    public SyslogParserBuilder withKeyProvider(KeyProvider keyProvider) {
        this.keyProvider = keyProvider;
        return this;
    }

    public SyslogParserBuilder withNilPolicy(NilPolicy nilPolicy) {
        this.nilPolicy = nilPolicy;
        return this;
    }

    public SyslogParserBuilder withStructuredDataPolicy(StructuredDataPolicy structuredDataPolicy) {
        this.structuredDataPolicy = structuredDataPolicy;
        return this;
    }

    public SyslogParser build() {
        if (this.specification == SyslogSpecification.RFC_5424) {
            return new Rfc5424SyslogParser(this.keyProvider, this.nilPolicy, this.structuredDataPolicy, this.deviations);
        }
        return new Rfc3164SyslogParser(this.keyProvider, this.deviations);
    }
}

