/*
 * Decompiled with CFR 0.152.
 */
package com.github.palindromicity.syslog.dsl;

import com.github.palindromicity.syslog.AllowableDeviations;
import com.github.palindromicity.syslog.KeyProvider;
import com.github.palindromicity.syslog.dsl.MessageMapProvider;
import com.github.palindromicity.syslog.dsl.ParseException;
import com.github.palindromicity.syslog.dsl.generated.Rfc3164BaseListener;
import com.github.palindromicity.syslog.dsl.generated.Rfc3164Parser;
import com.github.palindromicity.syslog.util.Validate;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class Syslog3164Listener
extends Rfc3164BaseListener
implements MessageMapProvider {
    private KeyProvider keyProvider;
    private EnumSet<AllowableDeviations> deviations;
    private final Map<String, Object> msgMap = new HashMap<String, Object>();

    public Syslog3164Listener(KeyProvider keyProvider, EnumSet<AllowableDeviations> deviations) {
        Validate.notNull(keyProvider, "keyProvider");
        this.keyProvider = keyProvider;
        this.deviations = deviations;
    }

    @Override
    public Map<String, Object> getMessageMap() {
        if (this.msgMap.get(this.keyProvider.getHeaderPriority()) == null && !this.deviations.contains((Object)AllowableDeviations.PRIORITY)) {
            throw new ParseException("Priority missing with strict parsing");
        }
        return Collections.unmodifiableMap(this.msgMap);
    }

    @Override
    public void exitHeaderPriorityValue(Rfc3164Parser.HeaderPriorityValueContext ctx) {
        String priority = ctx.getText();
        this.msgMap.put(this.keyProvider.getHeaderPriority(), priority);
        int pri = Integer.parseInt(priority);
        int sev = pri % 8;
        int facility = pri / 8;
        this.msgMap.put(this.keyProvider.getHeaderSeverity(), String.valueOf(sev));
        this.msgMap.put(this.keyProvider.getHeaderFacility(), String.valueOf(facility));
    }

    @Override
    public void exitHeaderHostName(Rfc3164Parser.HeaderHostNameContext ctx) {
        this.msgMap.put(this.keyProvider.getHeaderHostName(), ctx.getText());
    }

    @Override
    public void exitHeaderTimeStamp(Rfc3164Parser.HeaderTimeStampContext ctx) {
        this.msgMap.put(this.keyProvider.getHeaderTimeStamp(), ctx.full_date().getText() + "T" + ctx.full_time().getText());
    }

    @Override
    public void exitHeaderTimeStamp3164(Rfc3164Parser.HeaderTimeStamp3164Context ctx) {
        this.msgMap.put(this.keyProvider.getHeaderTimeStamp(), String.format("%s%s %s", ctx.date_month_short().getText(), ctx.date_day_short().getText(), ctx.partial_time().getText()));
    }

    @Override
    public void exitMsg_any(Rfc3164Parser.Msg_anyContext ctx) {
        this.msgMap.put(this.keyProvider.getMessage(), ctx.getText().trim());
    }

    @Override
    public void exitMsg_utf8(Rfc3164Parser.Msg_utf8Context ctx) {
        this.msgMap.put(this.keyProvider.getMessage(), ctx.getText().trim());
    }
}

