/*
 * Decompiled with CFR 0.152.
 */
package com.github.parboiled1.grappa.matchers.trie;

import com.github.parboiled1.grappa.matchers.trie.TrieBuilder;
import com.github.parboiled1.grappa.matchers.trie.TrieNode;
import com.google.common.annotations.Beta;
import javax.annotation.concurrent.Immutable;

@Immutable
@Beta
public final class Trie {
    private final int nrWords;
    private final int maxLength;
    private final TrieNode node;

    public static TrieBuilder newBuilder() {
        return new TrieBuilder();
    }

    public int getNrWords() {
        return this.nrWords;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public boolean trieHasStart(char c) {
        return this.node.hasNextChar(c);
    }

    public int search(String needle) {
        return this.node.search(needle);
    }

    Trie(TrieBuilder builder) {
        this.nrWords = builder.nrWords;
        this.maxLength = builder.maxLength;
        this.node = builder.nodeBuilder.build();
    }
}

