/*
 * Decompiled with CFR 0.152.
 */
package com.github.parboiled1.grappa.matchers.unicode;

import com.github.parboiled1.grappa.matchers.unicode.UnicodeRangeMatcher;
import org.parboiled.MatcherContext;

public class GenericSupplementaryRangeMatcher
extends UnicodeRangeMatcher {
    private final char[] lowChars;
    private final char[] highChars;
    private final int low;
    private final int high;

    GenericSupplementaryRangeMatcher(String label, char[] lowChars, char[] highChars) {
        super(label);
        this.lowChars = lowChars;
        this.highChars = highChars;
        this.low = Character.toCodePoint(lowChars[0], lowChars[1]);
        this.high = Character.toCodePoint(highChars[0], highChars[1]);
    }

    @Override
    public boolean isSingleCharMatcher() {
        return false;
    }

    @Override
    public boolean canMatchEmpty() {
        return false;
    }

    @Override
    public boolean isStarterChar(char c) {
        return c >= this.lowChars[0] && c <= this.highChars[0];
    }

    @Override
    public char getStarterChar() {
        return this.lowChars[0];
    }

    @Override
    public <V> boolean match(MatcherContext<V> context) {
        int index = context.getCurrentIndex();
        String tmp = context.getInputBuffer().extract(index, index + 2);
        int tested = Character.codePointAt(tmp, 0);
        if (tested < this.low || tested > this.high) {
            return false;
        }
        context.advanceIndex(2);
        context.createNode();
        return true;
    }
}

