/*
 * Decompiled with CFR 0.152.
 */
package com.github.parboiled1.grappa.stack;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.parboiled.errors.GrammarException;
import org.parboiled.support.ValueStack;

public final class DefaultValueStack<V>
implements ValueStack<V> {
    private List<V> stack = new ArrayList<V>();

    @Override
    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    @Override
    public int size() {
        return this.stack.size();
    }

    @Override
    public void clear() {
        this.stack.clear();
    }

    @Override
    public Object takeSnapshot() {
        return new ArrayList<V>(this.stack);
    }

    @Override
    public void restoreSnapshot(Object snapshot) {
        if (snapshot == null) {
            this.stack = new ArrayList<V>();
            return;
        }
        Preconditions.checkState((snapshot.getClass() == ArrayList.class ? 1 : 0) != 0);
        this.stack = (List)snapshot;
    }

    @Override
    public void push(V value) {
        this.push(0, value);
    }

    @Override
    public void push(int down, V value) {
        try {
            this.checkSize(down - 1);
            this.stack.add(down, value);
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public void pushAll(@Nullable V firstValue, V ... moreValues) {
        if (firstValue instanceof Iterable && moreValues != null && moreValues.length == 0) {
            Iterable values = (Iterable)firstValue;
            this.pushAll(values);
            return;
        }
        ArrayList<V> temp = new ArrayList<V>();
        temp.add(firstValue);
        if (moreValues == null) {
            temp.add(null);
        } else {
            temp.addAll(Arrays.asList(moreValues));
        }
        this.pushAll(temp);
    }

    @Override
    public void pushAll(@Nonnull Iterable<V> values) {
        ArrayList newStack = Lists.newArrayList(values);
        newStack.addAll(this.stack);
        this.stack = newStack;
    }

    @Override
    public V pop() {
        Preconditions.checkArgument((!this.stack.isEmpty() ? 1 : 0) != 0, (Object)"stack is empty");
        return this.stack.remove(0);
    }

    @Override
    public V pop(int down) {
        try {
            this.checkSize(down);
            return this.stack.remove(down);
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public V peek() {
        Preconditions.checkArgument((!this.stack.isEmpty() ? 1 : 0) != 0, (Object)"stack is empty");
        return this.stack.get(0);
    }

    @Override
    public V peek(int down) {
        try {
            this.checkSize(down);
            return this.stack.get(down);
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public void poke(@Nullable V value) {
        Preconditions.checkArgument((!this.stack.isEmpty() ? 1 : 0) != 0, (Object)"stack is empty");
        this.poke(0, value);
    }

    @Override
    public void poke(int down, @Nullable V value) {
        try {
            this.checkSize(down);
            this.stack.set(down, value);
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public void dup() {
        Preconditions.checkArgument((!this.stack.isEmpty() ? 1 : 0) != 0, (Object)"stack is empty");
        V element = this.stack.get(0);
        this.stack.add(0, element);
    }

    @Override
    public void swap(int n) {
        Preconditions.checkArgument((n >= 2 ? 1 : 0) != 0, (Object)("illegal argument to swap() (" + n + "), must be 2 or greater"));
        this.checkSize(n - 1);
        Collections.reverse(this.stack.subList(0, n));
    }

    @Override
    public void swap() {
        try {
            this.swap(2);
        }
        catch (IllegalStateException e) {
            throw new GrammarException(e.getMessage());
        }
    }

    @Override
    public void swap3() {
        try {
            this.swap(3);
        }
        catch (IllegalStateException e) {
            throw new GrammarException(e.getMessage());
        }
    }

    @Override
    public void swap4() {
        try {
            this.swap(4);
        }
        catch (IllegalStateException e) {
            throw new GrammarException(e.getMessage());
        }
    }

    @Override
    public void swap5() {
        try {
            this.swap(5);
        }
        catch (IllegalStateException e) {
            throw new GrammarException(e.getMessage());
        }
    }

    @Override
    public void swap6() {
        try {
            this.swap(6);
        }
        catch (IllegalStateException e) {
            throw new GrammarException(e.getMessage());
        }
    }

    @Override
    public Iterator<V> iterator() {
        return Iterators.unmodifiableIterator(this.stack.iterator());
    }

    @Nonnull
    public String toString() {
        return this.stack.toString();
    }

    private void checkSize(int index) {
        Preconditions.checkState((index < this.stack.size() ? 1 : 0) != 0, (Object)"not enough elements in stack");
    }
}

