/*
 * Decompiled with CFR 0.152.
 */
package com.github.parboiled1.grappa.transform.method;

import com.google.common.collect.ImmutableMap;
import java.lang.annotation.Annotation;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Type;
import org.parboiled.annotations.BuildParseTree;
import org.parboiled.annotations.Cached;
import org.parboiled.annotations.DontExtend;
import org.parboiled.annotations.DontLabel;
import org.parboiled.annotations.DontSkipActionsInPredicates;
import org.parboiled.annotations.ExplicitActionsOnly;
import org.parboiled.annotations.MemoMismatches;
import org.parboiled.annotations.SkipActionsInPredicates;
import org.parboiled.annotations.SkipNode;
import org.parboiled.annotations.SuppressNode;
import org.parboiled.annotations.SuppressSubnodes;

public enum ParserAnnotation {
    BUILD_PARSE_TREE(BuildParseTree.class),
    CACHED(Cached.class),
    EXPLICIT_ACTIONS_ONLY(ExplicitActionsOnly.class),
    DONT_LABEL(DontLabel.class),
    DONT_EXTEND(DontExtend.class),
    DONT_SKIP_ACTIONS_IN_PREDICATES(DontSkipActionsInPredicates.class),
    MEMO_MISMATCHES(MemoMismatches.class),
    SKIP_ACTIONS_IN_PREDICATES(SkipActionsInPredicates.class),
    SKIP_NODE(SkipNode.class),
    SUPPRESS_NODE(SuppressNode.class),
    SUPPRESS_SUBNODES(SuppressSubnodes.class);

    private static final Set<ParserAnnotation> FLAGS_COPY;
    private static final Set<ParserAnnotation> FLAGS_CLEAR;
    private static final Set<ParserAnnotation> FLAGS_SET;
    private static final Map<String, ParserAnnotation> REVERSE_MAP;
    private final String descriptor;

    private ParserAnnotation(Class<? extends Annotation> c) {
        this.descriptor = Type.getType(c).getDescriptor();
    }

    public static boolean recordAnnotation(Set<ParserAnnotation> set, String desc) {
        ParserAnnotation annotation = REVERSE_MAP.get(desc);
        if (annotation == null) {
            return false;
        }
        set.add(annotation);
        return true;
    }

    public static void moveTo(Set<ParserAnnotation> from, Set<ParserAnnotation> to) {
        EnumSet<ParserAnnotation> transferred = EnumSet.copyOf(from);
        transferred.retainAll(FLAGS_COPY);
        to.addAll(transferred);
        from.addAll(FLAGS_SET);
        from.removeAll(FLAGS_CLEAR);
    }

    static {
        FLAGS_COPY = EnumSet.of(CACHED, new ParserAnnotation[]{DONT_LABEL, SUPPRESS_NODE, SUPPRESS_SUBNODES, SKIP_NODE, MEMO_MISMATCHES});
        FLAGS_CLEAR = EnumSet.of(CACHED, SUPPRESS_NODE, SUPPRESS_SUBNODES, SKIP_NODE, MEMO_MISMATCHES);
        FLAGS_SET = EnumSet.of(DONT_LABEL);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ParserAnnotation entry : ParserAnnotation.values()) {
            builder.put((Object)entry.descriptor, (Object)entry);
        }
        REVERSE_MAP = builder.build();
    }
}

